# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HubSpotContact(UniversalBaseModel):
    """
    HubSpot Contact object.
    Can be associated with: Companies.
    """

    firstname: str = pydantic.Field()
    """
    Contact first name
    """

    lastname: str = pydantic.Field()
    """
    Contact last name
    """

    email: str = pydantic.Field()
    """
    Contact email address
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Contact phone number
    """

    job_title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Contact job title
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
