# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HubSpotCompany(UniversalBaseModel):
    """
    HubSpot Company object.
    Base object, typically doesn't associate upwards in this schema, but contacts/deals associate to it.
    """

    name: str = pydantic.Field()
    """
    Company name
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company domain/website
    """

    industry: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company industry
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company city
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company state/region
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company country
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Company phone number
    """

    number_of_employees: typing.Optional[str] = pydantic.Field(default=None)
    """
    Number of employees
    """

    annual_revenue: typing.Optional[str] = pydantic.Field(default=None)
    """
    Annual revenue
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
