# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GoogleSheetsSheetProperties(UniversalBaseModel):
    """
    Properties for a sheet within a spreadsheet
    """

    title: str = pydantic.Field()
    """
    Sheet title (required)
    """

    index: typing.Optional[int] = pydantic.Field(default=None)
    """
    Sheet index position
    """

    grid_properties: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="gridProperties")
    ] = pydantic.Field(default=None)
    """
    Grid properties (rowCount, columnCount)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
