# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .google_sheets_grid_data import GoogleSheetsGridData
from .google_sheets_sheet_properties import GoogleSheetsSheetProperties


class GoogleSheetsSheet(UniversalBaseModel):
    """
    A sheet within a Google Sheets spreadsheet
    """

    properties: GoogleSheetsSheetProperties = pydantic.Field()
    """
    Sheet properties (required)
    """

    data: typing.Optional[typing.List[GoogleSheetsGridData]] = pydantic.Field(default=None)
    """
    Grid data for the sheet
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
