# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GoogleFormsItem(UniversalBaseModel):
    """
    Form item - matches API Item object. Uses Dict for flexibility to match API structure.
    """

    item_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="itemId")] = pydantic.Field(
        default=None
    )
    """
    The item ID
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the item
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the item
    """

    question_item: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="questionItem")
    ] = pydantic.Field(default=None)
    """
    Poses a question to the user
    """

    question_group_item: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="questionGroupItem")
    ] = pydantic.Field(default=None)
    """
    Poses one or more questions with a single major prompt
    """

    page_break_item: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="pageBreakItem")
    ] = pydantic.Field(default=None)
    """
    Starts a new page with a title
    """

    text_item: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="textItem")
    ] = pydantic.Field(default=None)
    """
    Displays a title and description on the page
    """

    image_item: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="imageItem")
    ] = pydantic.Field(default=None)
    """
    Displays an image on the page
    """

    video_item: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="videoItem")
    ] = pydantic.Field(default=None)
    """
    Displays a video on the page
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
