# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GoogleFormsInfo(UniversalBaseModel):
    """
    Form info - matches API Info object
    """

    title: str = pydantic.Field()
    """
    The title of the form visible to responders
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the form
    """

    document_title: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="documentTitle")] = (
        pydantic.Field(default=None)
    )
    """
    The title of the document visible in Drive (output only, can be set on create)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
