# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .google_forms_form_settings import GoogleFormsFormSettings
from .google_forms_info import GoogleFormsInfo
from .google_forms_item import GoogleFormsItem


class GoogleFormsForm(UniversalBaseModel):
    """
    Google Forms form object - matches API Form resource
    """

    info: GoogleFormsInfo = pydantic.Field()
    """
    Required. The title and description of the form
    """

    settings: typing.Optional[GoogleFormsFormSettings] = pydantic.Field(default=None)
    """
    The form's settings
    """

    items: typing.Optional[typing.List[GoogleFormsItem]] = pydantic.Field(default=None)
    """
    A list of the form's items
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
