# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GoogleDriveFile(UniversalBaseModel):
    """
    Google Drive file or folder object
    """

    name: str = pydantic.Field()
    """
    Name of the file or folder (required)
    """

    mime_type: typing_extensions.Annotated[str, FieldMetadata(alias="mimeType")] = pydantic.Field()
    """
    MIME type of the file (required). Use 'application/vnd.google-apps.folder' for folders
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the file
    """

    parents: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of parent folder IDs
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text content for Google Docs documents
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
