# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GoogleCalendarEventDateTime(UniversalBaseModel):
    """
    Event date/time with timezone support
    """

    date_time: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="dateTime")] = pydantic.Field(
        default=None
    )
    """
    RFC3339 timestamp (e.g., 2025-12-01T09:00:00-07:00)
    """

    date: typing.Optional[str] = pydantic.Field(default=None)
    """
    All-day event date in YYYY-MM-DD format
    """

    time_zone: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="timeZone")] = pydantic.Field(
        default=None
    )
    """
    IANA timezone (e.g., America/Los_Angeles)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
