# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .google_calendar_attendee import GoogleCalendarAttendee
from .google_calendar_event_date_time import GoogleCalendarEventDateTime


class GoogleCalendarEvent(UniversalBaseModel):
    """
    Google Calendar event object
    """

    summary: str = pydantic.Field()
    """
    Event title/summary (required)
    """

    start: GoogleCalendarEventDateTime = pydantic.Field()
    """
    Event start time (required)
    """

    end: GoogleCalendarEventDateTime = pydantic.Field()
    """
    Event end time (required)
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Event description
    """

    location: typing.Optional[str] = pydantic.Field(default=None)
    """
    Event location
    """

    attendees: typing.Optional[typing.List[GoogleCalendarAttendee]] = pydantic.Field(default=None)
    """
    List of event attendees
    """

    color_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="colorId")] = pydantic.Field(
        default=None
    )
    """
    Event color (1-11)
    """

    visibility: typing.Optional[str] = pydantic.Field(default=None)
    """
    Visibility (default, public, private, confidential)
    """

    transparency: typing.Optional[str] = pydantic.Field(default=None)
    """
    Transparency (opaque, transparent)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
