# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GmailDraft(UniversalBaseModel):
    """
    Gmail Draft object with essential fields
    """

    subject: str = pydantic.Field()
    """
    Draft subject (required)
    """

    to: str = pydantic.Field()
    """
    Recipient email address (required)
    """

    cc: typing.Optional[str] = pydantic.Field(default=None)
    """
    CC email addresses (comma-separated)
    """

    bcc: typing.Optional[str] = pydantic.Field(default=None)
    """
    BCC email addresses (comma-separated)
    """

    body: str = pydantic.Field()
    """
    Draft body content (required)
    """

    from_: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="from")] = pydantic.Field(default=None)
    """
    Sender email address (optional, defaults to authenticated user)
    """

    reply_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reply-to email address
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
