# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .gmail_draft import GmailDraft
from .gmail_message import GmailMessage


class GmailData(UniversalBaseModel):
    """
    Complete Gmail sandbox data structure with all supported objects
    """

    messages: typing.Optional[typing.List[GmailMessage]] = pydantic.Field(default=None)
    """
    List of Gmail messages to send
    """

    drafts: typing.Optional[typing.List[GmailDraft]] = pydantic.Field(default=None)
    """
    List of Gmail drafts to create
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
