# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .git_hub_branch import GitHubBranch
from .git_hub_issue import GitHubIssue
from .git_hub_pull_request import GitHubPullRequest


class GitHubRepo(UniversalBaseModel):
    """
    GitHub Repository object
    """

    name: str = pydantic.Field()
    """
    Repository name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Repository description
    """

    branches: typing.Optional[typing.List[GitHubBranch]] = pydantic.Field(default=None)
    """
    List of branches with their folder structures
    """

    prs: typing.Optional[typing.List[GitHubPullRequest]] = pydantic.Field(default=None)
    """
    List of pull requests
    """

    issues: typing.Optional[typing.List[GitHubIssue]] = pydantic.Field(default=None)
    """
    List of issues
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(GitHubRepo)
