# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GitHubPullRequest(UniversalBaseModel):
    """
    GitHub Pull Request object
    """

    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    PR ID (read-only, set by GitHub)
    """

    title: str = pydantic.Field()
    """
    Pull request title
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    Pull request description/body
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    PR state: open, closed, or merged
    """

    head: str = pydantic.Field()
    """
    Head branch name
    """

    base: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base branch name
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of label names
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
