# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GitHubIssue(UniversalBaseModel):
    """
    GitHub Issue object
    """

    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    Issue ID (read-only, set by GitHub)
    """

    title: str = pydantic.Field()
    """
    Issue title
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    Issue description/body
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    Issue state: open or closed
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of label names
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
