# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .git_hub_file import GitHubFile


class GitHubFolder(UniversalBaseModel):
    """
    GitHub Folder object
    """

    name: str = pydantic.Field()
    """
    Folder name
    """

    path: str = pydantic.Field()
    """
    Folder path within the repository
    """

    files: typing.Optional[typing.List[GitHubFile]] = pydantic.Field(default=None)
    """
    Files within this folder
    """

    folders: typing.Optional[typing.List["GitHubFolder"]] = pydantic.Field(default=None)
    """
    Subfolders within this folder
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(GitHubFolder)
