# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GitHubFile(UniversalBaseModel):
    """
    GitHub File object
    """

    name: str = pydantic.Field()
    """
    File name
    """

    path: str = pydantic.Field()
    """
    File path within the repository
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    File content (base64 encoded for binary files)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
