# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs


class GitHubBranch(UniversalBaseModel):
    """
    GitHub Branch object
    """

    name: str = pydantic.Field()
    """
    Branch name
    """

    folders: typing.Optional["GitHubFolder"] = pydantic.Field(default=None)
    """
    Root folder structure for this branch
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .git_hub_folder import GitHubFolder  # noqa: E402, I001

update_forward_refs(GitHubBranch)
