# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class GetUserAuthResponse(UniversalBaseModel):
    success: bool
    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")] = pydantic.Field()
    """
    The user identifier
    """

    server_name: typing_extensions.Annotated[str, FieldMetadata(alias="serverName")] = pydantic.Field()
    """
    The name of the server
    """

    auth_data: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="authData")
    ] = pydantic.Field(default=None)
    """
    The authentication data if available
    """

    is_authenticated: typing_extensions.Annotated[bool, FieldMetadata(alias="isAuthenticated")] = pydantic.Field()
    """
    Whether the server has authentication data configured
    """

    message: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
