# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .outlook_mail_data import OutlookMailData
from .sandbox_mcp_server import SandboxMcpServer


class DumpSandboxResponseOutlookMailData(UniversalBaseModel):
    sandbox_id: str = pydantic.Field()
    """
    Sandbox identifier
    """

    server_name: SandboxMcpServer = pydantic.Field()
    """
    MCP server type
    """

    dumped_at: dt.datetime = pydantic.Field()
    """
    Timestamp of dump
    """

    data: OutlookMailData = pydantic.Field()
    """
    Dumped sandbox data in server-specific format
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
