# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .one_drive_data import OneDriveData
from .sandbox_mcp_server import SandboxMcpServer


class DumpSandboxResponseOneDriveData(UniversalBaseModel):
    sandbox_id: str = pydantic.Field()
    """
    Sandbox identifier
    """

    server_name: SandboxMcpServer = pydantic.Field()
    """
    MCP server type
    """

    dumped_at: dt.datetime = pydantic.Field()
    """
    Timestamp of dump
    """

    data: OneDriveData = pydantic.Field()
    """
    Dumped sandbox data in server-specific format
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(DumpSandboxResponseOneDriveData)
