# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DropboxFile(UniversalBaseModel):
    """
    Dropbox file data

    Attributes:
        path: Full path to the file (e.g., "/SandboxTest/document.txt")
        content: Text content of the file
    """

    path: str = pydantic.Field()
    """
    Full path to the file (must start with /SandboxTest/)
    """

    content: str = pydantic.Field()
    """
    Text content of the file
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
