# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dropbox_file import DropboxFile


class DropboxData(UniversalBaseModel):
    """
    Complete Dropbox sandbox data structure

    Describes the folder and file structure to be created in the sandbox.
    Folders are created in the order specified, and files are uploaded after
    all folders have been created.

    Note: The root folder /SandboxTest is always created first automatically.
    Additional folders should be nested within /SandboxTest.
    """

    folders: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of folder paths to create (e.g., ['/SandboxTest', '/SandboxTest/Documents'])
    """

    files: typing.Optional[typing.List[DropboxFile]] = pydantic.Field(default=None)
    """
    List of files to create with their content
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
