# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .sandbox_mcp_server import SandboxMcpServer
from .sandbox_status import SandboxStatus


class CreateSandboxResponse(UniversalBaseModel):
    """
    Response model for sandbox acquisition
    """

    sandbox_id: str = pydantic.Field()
    """
    Unique identifier for the acquired sandbox
    """

    server_url: str = pydantic.Field()
    """
    URL to connect to the MCP server
    """

    server_name: SandboxMcpServer = pydantic.Field()
    """
    The MCP server name
    """

    status: SandboxStatus = pydantic.Field()
    """
    Current status of the sandbox
    """

    message: str = pydantic.Field()
    """
    Status message
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
