# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs


class ConfluenceSpace(UniversalBaseModel):
    """
    Confluence Space object
    """

    key: str = pydantic.Field()
    """
    Space key (e.g., DS)
    """

    name: str = pydantic.Field()
    """
    Space name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Space description
    """

    pages: typing.Optional[typing.List["ConfluencePage"]] = pydantic.Field(default=None)
    """
    Root pages in this space
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .confluence_page import ConfluencePage  # noqa: E402, I001

update_forward_refs(ConfluenceSpace)
