# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .confluence_comment import ConfluenceComment


class ConfluencePage(UniversalBaseModel):
    """
    Confluence Page object
    """

    title: str = pydantic.Field()
    """
    Page title
    """

    body: str = pydantic.Field()
    """
    Page content (storage format)
    """

    children: typing.Optional[typing.List["ConfluencePage"]] = pydantic.Field(default=None)
    """
    Child pages
    """

    comments: typing.Optional[typing.List[ConfluenceComment]] = pydantic.Field(default=None)
    """
    Comments on this page
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(ConfluencePage)
