# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CloseTask(UniversalBaseModel):
    """
    Close Task object - child of Lead
    """

    text: str = pydantic.Field()
    """
    Task description
    """

    date: typing.Optional[str] = pydantic.Field(default=None)
    """
    The date of a task represents the point in time of when the task is actionable and appears in the inbox
    """

    is_complete: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether task is completed
    """

    assigned_to: typing.Optional[str] = pydantic.Field(default=None)
    """
    User ID assigned to
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
