# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .close_contact import CloseContact
from .close_opportunity import CloseOpportunity
from .close_task import CloseTask


class CloseLead(UniversalBaseModel):
    """
    Close Lead object - parent object containing contacts, opportunities, and tasks
    """

    name: str = pydantic.Field()
    """
    Lead name/company name
    """

    status_label: typing.Optional[str] = pydantic.Field(default=None)
    """
    Lead status
    """

    contacts: typing.Optional[typing.List[CloseContact]] = pydantic.Field(default=None)
    """
    Contacts associated with this lead
    """

    opportunities: typing.Optional[typing.List[CloseOpportunity]] = pydantic.Field(default=None)
    """
    Opportunities associated with this lead
    """

    tasks: typing.Optional[typing.List[CloseTask]] = pydantic.Field(default=None)
    """
    Tasks associated with this lead
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
