# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .click_up_comment import ClickUpComment


class ClickUpTask(UniversalBaseModel):
    """
    ClickUp Task object
    """

    name: str = pydantic.Field()
    """
    Task name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Task description
    """

    priority: typing.Optional[int] = pydantic.Field(default=None)
    """
    Task priority (1-4)
    """

    comments: typing.Optional[typing.List[ClickUpComment]] = pydantic.Field(default=None)
    """
    Comments on this task
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
