# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .click_up_task import ClickUpTask


class ClickUpList(UniversalBaseModel):
    """
    ClickUp List object
    """

    name: str = pydantic.Field()
    """
    List name
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    List description/content
    """

    tasks: typing.Optional[typing.List[ClickUpTask]] = pydantic.Field(default=None)
    """
    Tasks in this list
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
