# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .override import Override
from .time_slot import TimeSlot


class CalcomSchedule(UniversalBaseModel):
    """
    Schedule data for creating a new schedule via Cal.com API.

    Attributes:
        name: Human-readable schedule name
        timeZone: IANA timezone (e.g., "America/New_York")
        isDefault: Whether this is the default schedule for the user
        availability: List of recurring time slots (optional, defaults to Mon-Fri 9-17)
        overrides: List of date-specific availability overrides (optional)
    """

    name: str = pydantic.Field()
    """
    Human-readable schedule name
    """

    time_zone: typing_extensions.Annotated[str, FieldMetadata(alias="timeZone")] = pydantic.Field()
    """
    IANA timezone (e.g., 'America/New_York')
    """

    is_default: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isDefault")] = pydantic.Field(
        default=None
    )
    """
    Whether this is the default schedule
    """

    availability: typing.Optional[typing.List[TimeSlot]] = pydantic.Field(default=None)
    """
    List of recurring time slots
    """

    overrides: typing.Optional[typing.List[Override]] = pydantic.Field(default=None)
    """
    List of date-specific availability overrides
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
