# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .asana_story import AsanaStory


class AsanaTask(UniversalBaseModel):
    """
    Asana Task object
    """

    gid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Globally unique identifier of the resource (read-only, set by Asana)
    """

    name: str = pydantic.Field()
    """
    Task name
    """

    notes: typing.Optional[str] = pydantic.Field(default=None)
    """
    Task notes/description
    """

    completed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether task is completed
    """

    assignee: typing.Optional[str] = pydantic.Field(default=None)
    """
    User GID assigned to task
    """

    due_on: typing.Optional[str] = pydantic.Field(default=None)
    """
    Due date (YYYY-MM-DD)
    """

    due_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    Due datetime (ISO 8601)
    """

    start_on: typing.Optional[str] = pydantic.Field(default=None)
    """
    Start date (YYYY-MM-DD)
    """

    stories: typing.Optional[typing.List[AsanaStory]] = pydantic.Field(default=None)
    """
    Stories (comments) on this task
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
