# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .asana_task import AsanaTask


class AsanaProject(UniversalBaseModel):
    """
    Asana Project object
    """

    gid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project GID (read-only, set by Asana)
    """

    name: str = pydantic.Field()
    """
    Project name
    """

    notes: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project notes/description
    """

    tasks: typing.Optional[typing.List[AsanaTask]] = pydantic.Field(default=None)
    """
    Tasks in this project
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
