# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .airtable_field import AirtableField
from .airtable_record import AirtableRecord


class AirtableTable(UniversalBaseModel):
    """
    Airtable Table object
    """

    name: str = pydantic.Field()
    """
    Table name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Table description
    """

    fields: typing.Optional[typing.List[AirtableField]] = pydantic.Field(default=None)
    """
    Field definitions for this table
    """

    records: typing.Optional[typing.List[AirtableRecord]] = pydantic.Field(default=None)
    """
    Records in this table
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
