# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AirtableField(UniversalBaseModel):
    """
    Airtable Field definition (column schema)
    """

    name: str = pydantic.Field()
    """
    Field name
    """

    type: str = pydantic.Field()
    """
    Field type (singleLineText, multilineText, number, singleSelect, multipleSelects, date, checkbox, url, email, phoneNumber, attachment, etc.)
    """

    options: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Field options (e.g., choices for select fields)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
