# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.sharesight_o_auth_success_response import SharesightOAuthSuccessResponse
from .raw_client import AsyncRawSharesightOauthClient, RawSharesightOauthClient


class SharesightOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSharesightOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSharesightOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSharesightOauthClient
        """
        return self._raw_client

    def authorize_sharesight(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.sharesight_oauth.authorize_sharesight(
            instance_id="instance_id",
            client_id="client_id",
            scope="scope",
            redirect_url="redirect_url",
        )
        """
        _response = self._raw_client.authorize_sharesight(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data

    def refresh_token(
        self, *, instance_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SharesightOAuthSuccessResponse:
        """
        Parameters
        ----------
        instance_id : str
            Instance ID for which to refresh the token

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SharesightOAuthSuccessResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.sharesight_oauth.refresh_token(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.refresh_token(instance_id=instance_id, request_options=request_options)
        return _response.data


class AsyncSharesightOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSharesightOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSharesightOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSharesightOauthClient
        """
        return self._raw_client

    async def authorize_sharesight(
        self,
        *,
        instance_id: str,
        client_id: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        redirect_url: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        instance_id : str
            Unique identifier for the client instance requesting authorization

        client_id : typing.Optional[str]
            Client ID for white labeling, if not provided will use default credentials

        scope : typing.Optional[str]
            Optional OAuth scopes to request (space-separated string)

        redirect_url : typing.Optional[str]
            Optional URL to redirect to after authorization completes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sharesight_oauth.authorize_sharesight(
                instance_id="instance_id",
                client_id="client_id",
                scope="scope",
                redirect_url="redirect_url",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.authorize_sharesight(
            instance_id=instance_id,
            client_id=client_id,
            scope=scope,
            redirect_url=redirect_url,
            request_options=request_options,
        )
        return _response.data

    async def refresh_token(
        self, *, instance_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SharesightOAuthSuccessResponse:
        """
        Parameters
        ----------
        instance_id : str
            Instance ID for which to refresh the token

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SharesightOAuthSuccessResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.sharesight_oauth.refresh_token(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.refresh_token(instance_id=instance_id, request_options=request_options)
        return _response.data
