# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.create_sandbox_response import CreateSandboxResponse
from ..types.dump_sandbox_response_snowflake_data import DumpSandboxResponseSnowflakeData
from ..types.http_validation_error import HttpValidationError
from ..types.initialize_sandbox_response import InitializeSandboxResponse
from ..types.release_sandbox_response import ReleaseSandboxResponse
from ..types.reset_sandbox_response import ResetSandboxResponse
from ..types.sandbox_info import SandboxInfo
from ..types.sandbox_mcp_server import SandboxMcpServer
from ..types.snowflake_database import SnowflakeDatabase

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSandboxClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_sandbox(
        self, server_name: SandboxMcpServer, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CreateSandboxResponse]:
        """
        Acquire an idle sandbox instance for a specific MCP server. The sandbox will be marked as 'occupied'.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateSandboxResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateSandboxResponse,
                    parse_obj_as(
                        type_=CreateSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_sandbox(
        self, server_name: SandboxMcpServer, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SandboxInfo]:
        """
        Retrieve detailed information about a specific sandbox instance.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SandboxInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}/{jsonable_encoder(sandbox_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SandboxInfo,
                    parse_obj_as(
                        type_=SandboxInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_sandbox(
        self, server_name: SandboxMcpServer, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ReleaseSandboxResponse]:
        """
        Release an occupied sandbox back to idle state and marks the sandbox as available for reuse.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ReleaseSandboxResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}/{jsonable_encoder(sandbox_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReleaseSandboxResponse,
                    parse_obj_as(
                        type_=ReleaseSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def reset_sandbox(
        self, server_name: SandboxMcpServer, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ResetSandboxResponse]:
        """
        Reset the sandbox to its initial empty state, clearing all data while maintaining the sandbox instance.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ResetSandboxResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}/{jsonable_encoder(sandbox_id)}/reset",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResetSandboxResponse,
                    parse_obj_as(
                        type_=ResetSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def initialize_sandbox(
        self,
        sandbox_id: str,
        *,
        databases: typing.Optional[typing.Sequence[SnowflakeDatabase]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[InitializeSandboxResponse]:
        """
        Initialize the sandbox with snowflake-specific data following the defined schema.

        Parameters
        ----------
        sandbox_id : str
            The unique sandbox identifier

        databases : typing.Optional[typing.Sequence[SnowflakeDatabase]]
            List of databases with their schemas

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[InitializeSandboxResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sandbox/snowflake/{jsonable_encoder(sandbox_id)}/initialize",
            method="POST",
            json={
                "databases": convert_and_respect_annotation_metadata(
                    object_=databases, annotation=typing.Sequence[SnowflakeDatabase], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InitializeSandboxResponse,
                    parse_obj_as(
                        type_=InitializeSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def dump_sandbox(
        self, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DumpSandboxResponseSnowflakeData]:
        """
        Export all data from the sandbox in the same format used for initialization.

        Parameters
        ----------
        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DumpSandboxResponseSnowflakeData]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"sandbox/snowflake/{jsonable_encoder(sandbox_id)}/dump",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DumpSandboxResponseSnowflakeData,
                    parse_obj_as(
                        type_=DumpSandboxResponseSnowflakeData,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSandboxClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_sandbox(
        self, server_name: SandboxMcpServer, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CreateSandboxResponse]:
        """
        Acquire an idle sandbox instance for a specific MCP server. The sandbox will be marked as 'occupied'.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateSandboxResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateSandboxResponse,
                    parse_obj_as(
                        type_=CreateSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_sandbox(
        self, server_name: SandboxMcpServer, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SandboxInfo]:
        """
        Retrieve detailed information about a specific sandbox instance.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SandboxInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}/{jsonable_encoder(sandbox_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SandboxInfo,
                    parse_obj_as(
                        type_=SandboxInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_sandbox(
        self, server_name: SandboxMcpServer, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ReleaseSandboxResponse]:
        """
        Release an occupied sandbox back to idle state and marks the sandbox as available for reuse.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ReleaseSandboxResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}/{jsonable_encoder(sandbox_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReleaseSandboxResponse,
                    parse_obj_as(
                        type_=ReleaseSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def reset_sandbox(
        self, server_name: SandboxMcpServer, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ResetSandboxResponse]:
        """
        Reset the sandbox to its initial empty state, clearing all data while maintaining the sandbox instance.

        Parameters
        ----------
        server_name : SandboxMcpServer
            The MCP server name

        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ResetSandboxResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sandbox/{jsonable_encoder(server_name)}/{jsonable_encoder(sandbox_id)}/reset",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ResetSandboxResponse,
                    parse_obj_as(
                        type_=ResetSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def initialize_sandbox(
        self,
        sandbox_id: str,
        *,
        databases: typing.Optional[typing.Sequence[SnowflakeDatabase]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[InitializeSandboxResponse]:
        """
        Initialize the sandbox with snowflake-specific data following the defined schema.

        Parameters
        ----------
        sandbox_id : str
            The unique sandbox identifier

        databases : typing.Optional[typing.Sequence[SnowflakeDatabase]]
            List of databases with their schemas

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[InitializeSandboxResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sandbox/snowflake/{jsonable_encoder(sandbox_id)}/initialize",
            method="POST",
            json={
                "databases": convert_and_respect_annotation_metadata(
                    object_=databases, annotation=typing.Sequence[SnowflakeDatabase], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    InitializeSandboxResponse,
                    parse_obj_as(
                        type_=InitializeSandboxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def dump_sandbox(
        self, sandbox_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DumpSandboxResponseSnowflakeData]:
        """
        Export all data from the sandbox in the same format used for initialization.

        Parameters
        ----------
        sandbox_id : str
            The unique sandbox identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DumpSandboxResponseSnowflakeData]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"sandbox/snowflake/{jsonable_encoder(sandbox_id)}/dump",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DumpSandboxResponseSnowflakeData,
                    parse_obj_as(
                        type_=DumpSandboxResponseSnowflakeData,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
