# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.azure_ado_auth_success_response import AzureAdoAuthSuccessResponse
from .raw_client import AsyncRawOutlookOauthClient, RawOutlookOauthClient


class OutlookOauthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOutlookOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOutlookOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOutlookOauthClient
        """
        return self._raw_client

    def refresh_token(
        self, *, instance_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AzureAdoAuthSuccessResponse:
        """
        Parameters
        ----------
        instance_id : str
            Instance ID for which to refresh the token

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AzureAdoAuthSuccessResponse
            Successful Response

        Examples
        --------
        from klavis import Klavis

        client = Klavis(
            api_key="YOUR_API_KEY",
        )
        client.outlook_oauth.refresh_token(
            instance_id="instance_id",
        )
        """
        _response = self._raw_client.refresh_token(instance_id=instance_id, request_options=request_options)
        return _response.data


class AsyncOutlookOauthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOutlookOauthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOutlookOauthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOutlookOauthClient
        """
        return self._raw_client

    async def refresh_token(
        self, *, instance_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AzureAdoAuthSuccessResponse:
        """
        Parameters
        ----------
        instance_id : str
            Instance ID for which to refresh the token

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AzureAdoAuthSuccessResponse
            Successful Response

        Examples
        --------
        import asyncio

        from klavis import AsyncKlavis

        client = AsyncKlavis(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.outlook_oauth.refresh_token(
                instance_id="instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.refresh_token(instance_id=instance_id, request_options=request_options)
        return _response.data
