# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import KlavisEnvironment

if typing.TYPE_CHECKING:
    from .google_cloud_oauth.client import AsyncGoogleCloudOauthClient, GoogleCloudOauthClient
    from .google_forms_oauth.client import AsyncGoogleFormsOauthClient, GoogleFormsOauthClient
    from .mcp_server.client import AsyncMcpServerClient, McpServerClient
    from .mscalendar_oauth.client import AsyncMscalendarOauthClient, MscalendarOauthClient
    from .oauth.client import AsyncOauthClient, OauthClient
    from .onedrive_oauth.client import AsyncOnedriveOauthClient, OnedriveOauthClient
    from .outlook_oauth.client import AsyncOutlookOauthClient, OutlookOauthClient
    from .sandbox.client import AsyncSandboxClient, SandboxClient
    from .sharesight_oauth.client import AsyncSharesightOauthClient, SharesightOauthClient
    from .teams_oauth.client import AsyncTeamsOauthClient, TeamsOauthClient
    from .user.client import AsyncUserClient, UserClient
    from .white_labeling.client import AsyncWhiteLabelingClient, WhiteLabelingClient
    from .zoom_oauth.client import AsyncZoomOauthClient, ZoomOauthClient


class Klavis:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : KlavisEnvironment
        The environment to use for requests from the client. from .environment import KlavisEnvironment



        Defaults to KlavisEnvironment.DEFAULT



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from klavis import Klavis

    client = Klavis(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: KlavisEnvironment = KlavisEnvironment.DEFAULT,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._mcp_server: typing.Optional[McpServerClient] = None
        self._white_labeling: typing.Optional[WhiteLabelingClient] = None
        self._user: typing.Optional[UserClient] = None
        self._oauth: typing.Optional[OauthClient] = None
        self._google_cloud_oauth: typing.Optional[GoogleCloudOauthClient] = None
        self._google_forms_oauth: typing.Optional[GoogleFormsOauthClient] = None
        self._onedrive_oauth: typing.Optional[OnedriveOauthClient] = None
        self._outlook_oauth: typing.Optional[OutlookOauthClient] = None
        self._mscalendar_oauth: typing.Optional[MscalendarOauthClient] = None
        self._teams_oauth: typing.Optional[TeamsOauthClient] = None
        self._zoom_oauth: typing.Optional[ZoomOauthClient] = None
        self._sharesight_oauth: typing.Optional[SharesightOauthClient] = None
        self._sandbox: typing.Optional[SandboxClient] = None

    @property
    def mcp_server(self):
        if self._mcp_server is None:
            from .mcp_server.client import McpServerClient  # noqa: E402

            self._mcp_server = McpServerClient(client_wrapper=self._client_wrapper)
        return self._mcp_server

    @property
    def white_labeling(self):
        if self._white_labeling is None:
            from .white_labeling.client import WhiteLabelingClient  # noqa: E402

            self._white_labeling = WhiteLabelingClient(client_wrapper=self._client_wrapper)
        return self._white_labeling

    @property
    def user(self):
        if self._user is None:
            from .user.client import UserClient  # noqa: E402

            self._user = UserClient(client_wrapper=self._client_wrapper)
        return self._user

    @property
    def oauth(self):
        if self._oauth is None:
            from .oauth.client import OauthClient  # noqa: E402

            self._oauth = OauthClient(client_wrapper=self._client_wrapper)
        return self._oauth

    @property
    def google_cloud_oauth(self):
        if self._google_cloud_oauth is None:
            from .google_cloud_oauth.client import GoogleCloudOauthClient  # noqa: E402

            self._google_cloud_oauth = GoogleCloudOauthClient(client_wrapper=self._client_wrapper)
        return self._google_cloud_oauth

    @property
    def google_forms_oauth(self):
        if self._google_forms_oauth is None:
            from .google_forms_oauth.client import GoogleFormsOauthClient  # noqa: E402

            self._google_forms_oauth = GoogleFormsOauthClient(client_wrapper=self._client_wrapper)
        return self._google_forms_oauth

    @property
    def onedrive_oauth(self):
        if self._onedrive_oauth is None:
            from .onedrive_oauth.client import OnedriveOauthClient  # noqa: E402

            self._onedrive_oauth = OnedriveOauthClient(client_wrapper=self._client_wrapper)
        return self._onedrive_oauth

    @property
    def outlook_oauth(self):
        if self._outlook_oauth is None:
            from .outlook_oauth.client import OutlookOauthClient  # noqa: E402

            self._outlook_oauth = OutlookOauthClient(client_wrapper=self._client_wrapper)
        return self._outlook_oauth

    @property
    def mscalendar_oauth(self):
        if self._mscalendar_oauth is None:
            from .mscalendar_oauth.client import MscalendarOauthClient  # noqa: E402

            self._mscalendar_oauth = MscalendarOauthClient(client_wrapper=self._client_wrapper)
        return self._mscalendar_oauth

    @property
    def teams_oauth(self):
        if self._teams_oauth is None:
            from .teams_oauth.client import TeamsOauthClient  # noqa: E402

            self._teams_oauth = TeamsOauthClient(client_wrapper=self._client_wrapper)
        return self._teams_oauth

    @property
    def zoom_oauth(self):
        if self._zoom_oauth is None:
            from .zoom_oauth.client import ZoomOauthClient  # noqa: E402

            self._zoom_oauth = ZoomOauthClient(client_wrapper=self._client_wrapper)
        return self._zoom_oauth

    @property
    def sharesight_oauth(self):
        if self._sharesight_oauth is None:
            from .sharesight_oauth.client import SharesightOauthClient  # noqa: E402

            self._sharesight_oauth = SharesightOauthClient(client_wrapper=self._client_wrapper)
        return self._sharesight_oauth

    @property
    def sandbox(self):
        if self._sandbox is None:
            from .sandbox.client import SandboxClient  # noqa: E402

            self._sandbox = SandboxClient(client_wrapper=self._client_wrapper)
        return self._sandbox


class AsyncKlavis:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : KlavisEnvironment
        The environment to use for requests from the client. from .environment import KlavisEnvironment



        Defaults to KlavisEnvironment.DEFAULT



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from klavis import AsyncKlavis

    client = AsyncKlavis(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: KlavisEnvironment = KlavisEnvironment.DEFAULT,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._mcp_server: typing.Optional[AsyncMcpServerClient] = None
        self._white_labeling: typing.Optional[AsyncWhiteLabelingClient] = None
        self._user: typing.Optional[AsyncUserClient] = None
        self._oauth: typing.Optional[AsyncOauthClient] = None
        self._google_cloud_oauth: typing.Optional[AsyncGoogleCloudOauthClient] = None
        self._google_forms_oauth: typing.Optional[AsyncGoogleFormsOauthClient] = None
        self._onedrive_oauth: typing.Optional[AsyncOnedriveOauthClient] = None
        self._outlook_oauth: typing.Optional[AsyncOutlookOauthClient] = None
        self._mscalendar_oauth: typing.Optional[AsyncMscalendarOauthClient] = None
        self._teams_oauth: typing.Optional[AsyncTeamsOauthClient] = None
        self._zoom_oauth: typing.Optional[AsyncZoomOauthClient] = None
        self._sharesight_oauth: typing.Optional[AsyncSharesightOauthClient] = None
        self._sandbox: typing.Optional[AsyncSandboxClient] = None

    @property
    def mcp_server(self):
        if self._mcp_server is None:
            from .mcp_server.client import AsyncMcpServerClient  # noqa: E402

            self._mcp_server = AsyncMcpServerClient(client_wrapper=self._client_wrapper)
        return self._mcp_server

    @property
    def white_labeling(self):
        if self._white_labeling is None:
            from .white_labeling.client import AsyncWhiteLabelingClient  # noqa: E402

            self._white_labeling = AsyncWhiteLabelingClient(client_wrapper=self._client_wrapper)
        return self._white_labeling

    @property
    def user(self):
        if self._user is None:
            from .user.client import AsyncUserClient  # noqa: E402

            self._user = AsyncUserClient(client_wrapper=self._client_wrapper)
        return self._user

    @property
    def oauth(self):
        if self._oauth is None:
            from .oauth.client import AsyncOauthClient  # noqa: E402

            self._oauth = AsyncOauthClient(client_wrapper=self._client_wrapper)
        return self._oauth

    @property
    def google_cloud_oauth(self):
        if self._google_cloud_oauth is None:
            from .google_cloud_oauth.client import AsyncGoogleCloudOauthClient  # noqa: E402

            self._google_cloud_oauth = AsyncGoogleCloudOauthClient(client_wrapper=self._client_wrapper)
        return self._google_cloud_oauth

    @property
    def google_forms_oauth(self):
        if self._google_forms_oauth is None:
            from .google_forms_oauth.client import AsyncGoogleFormsOauthClient  # noqa: E402

            self._google_forms_oauth = AsyncGoogleFormsOauthClient(client_wrapper=self._client_wrapper)
        return self._google_forms_oauth

    @property
    def onedrive_oauth(self):
        if self._onedrive_oauth is None:
            from .onedrive_oauth.client import AsyncOnedriveOauthClient  # noqa: E402

            self._onedrive_oauth = AsyncOnedriveOauthClient(client_wrapper=self._client_wrapper)
        return self._onedrive_oauth

    @property
    def outlook_oauth(self):
        if self._outlook_oauth is None:
            from .outlook_oauth.client import AsyncOutlookOauthClient  # noqa: E402

            self._outlook_oauth = AsyncOutlookOauthClient(client_wrapper=self._client_wrapper)
        return self._outlook_oauth

    @property
    def mscalendar_oauth(self):
        if self._mscalendar_oauth is None:
            from .mscalendar_oauth.client import AsyncMscalendarOauthClient  # noqa: E402

            self._mscalendar_oauth = AsyncMscalendarOauthClient(client_wrapper=self._client_wrapper)
        return self._mscalendar_oauth

    @property
    def teams_oauth(self):
        if self._teams_oauth is None:
            from .teams_oauth.client import AsyncTeamsOauthClient  # noqa: E402

            self._teams_oauth = AsyncTeamsOauthClient(client_wrapper=self._client_wrapper)
        return self._teams_oauth

    @property
    def zoom_oauth(self):
        if self._zoom_oauth is None:
            from .zoom_oauth.client import AsyncZoomOauthClient  # noqa: E402

            self._zoom_oauth = AsyncZoomOauthClient(client_wrapper=self._client_wrapper)
        return self._zoom_oauth

    @property
    def sharesight_oauth(self):
        if self._sharesight_oauth is None:
            from .sharesight_oauth.client import AsyncSharesightOauthClient  # noqa: E402

            self._sharesight_oauth = AsyncSharesightOauthClient(client_wrapper=self._client_wrapper)
        return self._sharesight_oauth

    @property
    def sandbox(self):
        if self._sandbox is None:
            from .sandbox.client import AsyncSandboxClient  # noqa: E402

            self._sandbox = AsyncSandboxClient(client_wrapper=self._client_wrapper)
        return self._sandbox


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: KlavisEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
