"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 */
class Schema {
    /**
     * Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits
     * @param scale the number of digits in fractional part, the default is 0
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     */
    static array(itemType) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_Type(itemType);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.array);
            }
            throw error;
        }
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     */
    static map(keyType, valueType) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_Type(keyType);
            jsiiDeprecationWarnings._aws_cdk_aws_glue_Type(valueType);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.map);
            }
            throw error;
        }
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
_a = JSII_RTTI_SYMBOL_1;
Schema[_a] = { fqn: "@aws-cdk/aws-glue.Schema", version: "1.166.1" };
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * Date type.
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * Timestamp type (date and time).
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * Arbitrary-length string type.
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,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