# nomad-envoy-cli
This is the API descriptor for the Nomad Envoy API, responsible for order operation and product lists. Developed by [Samarkand Global](https://samarkand.global) in partnership with [Youzan](https://www.youzan.com/), [LittleRED](https://www.xiaohongshu.com/), [PDD](http://www.pinduoduo.com/), etc. Read the documentation online at [Nomad API Suite](https://api.samarkand.io/).
- Install for node with `npm install nomad_envoy_cli`
- Install for python with `pip install nomad-envoy-cli`

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.51.0
- Package version: 1.51.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nomad_envoy_cli
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nomad_envoy_cli
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nomad_envoy_cli
from nomad_envoy_cli.rest import ApiException
from pprint import pprint

configuration = nomad_envoy_cli.Configuration()
# Configure API key authorization: ca_key
configuration.api_key['x-ca-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-ca-key'] = 'Bearer'
configuration = nomad_envoy_cli.Configuration()
# Configure API key authorization: ca_stage
configuration.api_key['x-ca-stage'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-ca-stage'] = 'Bearer'

# Defining host is optional and default to https://nomad.samarkand-global.cn/envoy
configuration.host = "https://nomad.samarkand-global.cn/envoy"
# Enter a context with an instance of the API client
with nomad_envoy_cli.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = nomad_envoy_cli.CustomsApi(api_client)
    region = 'region_example' # str | The region of the customs. e.g. shanghai
order = nomad_envoy_cli.Order() # Order | Order detail

    try:
        # postCustomsOrder
        api_response = api_instance.post_customs_order(region, order)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CustomsApi->post_customs_order: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://nomad.samarkand-global.cn/envoy*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CustomsApi* | [**post_customs_order**](docs/CustomsApi.md#post_customs_order) | **POST** /customs/{region}/order | postCustomsOrder
*CustomsApi* | [**post_customs_payment**](docs/CustomsApi.md#post_customs_payment) | **POST** /customs/{region}/payment | postCustomsPayment
*CustomsApi* | [**post_customs_product**](docs/CustomsApi.md#post_customs_product) | **POST** /customs/{region}/product | postCustomsProduct
*CustomsApi* | [**put_customs_order**](docs/CustomsApi.md#put_customs_order) | **PUT** /customs/{region}/order | putCustomsOrder
*CustomsCallbackApi* | [**post_customs_callback**](docs/CustomsCallbackApi.md#post_customs_callback) | **POST** /customs/{store} | postCustomsCallback
*OrderApi* | [**add_order**](docs/OrderApi.md#add_order) | **POST** /order/{store} | addOrder
*OrderApi* | [**cancel_order**](docs/OrderApi.md#cancel_order) | **DELETE** /order/{store} | cancelOrder
*OrderApi* | [**get_order_by_field**](docs/OrderApi.md#get_order_by_field) | **GET** /order/{store} | getOrderByField
*OrderApi* | [**update_order**](docs/OrderApi.md#update_order) | **PUT** /order/{store} | updateOrder
*ProductApi* | [**add_product**](docs/ProductApi.md#add_product) | **POST** /product/{store} | addProduct
*ProductApi* | [**delete_product**](docs/ProductApi.md#delete_product) | **DELETE** /product/{store} | deleteProduct
*ProductApi* | [**get_products_by_field**](docs/ProductApi.md#get_products_by_field) | **GET** /product/{store} | getProductsByField
*ProductApi* | [**update_product**](docs/ProductApi.md#update_product) | **PUT** /product/{store} | updateProduct
*StoreApi* | [**query_store**](docs/StoreApi.md#query_store) | **GET** /stores/ | queryStore


## Documentation For Models

 - [Address](docs/Address.md)
 - [ApiResponse](docs/ApiResponse.md)
 - [ApiResponseConnectorResponse](docs/ApiResponseConnectorResponse.md)
 - [ApiResponseData](docs/ApiResponseData.md)
 - [ApiResponseDataRequired](docs/ApiResponseDataRequired.md)
 - [ApiResponseGeneral](docs/ApiResponseGeneral.md)
 - [ApiResponseRequired](docs/ApiResponseRequired.md)
 - [BaseApiResponse](docs/BaseApiResponse.md)
 - [BaseApiResponseData](docs/BaseApiResponseData.md)
 - [CustomsDeclarationResult](docs/CustomsDeclarationResult.md)
 - [Gender](docs/Gender.md)
 - [Images](docs/Images.md)
 - [Order](docs/Order.md)
 - [OrderApiResponse](docs/OrderApiResponse.md)
 - [OrderApiResponseData](docs/OrderApiResponseData.md)
 - [OrderApiResponseDataRequired](docs/OrderApiResponseDataRequired.md)
 - [OrderApiResponseRequired](docs/OrderApiResponseRequired.md)
 - [OrderProduct](docs/OrderProduct.md)
 - [Product](docs/Product.md)
 - [ProductApiResponse](docs/ProductApiResponse.md)
 - [ProductApiResponseData](docs/ProductApiResponseData.md)
 - [ProductApiResponseRequired](docs/ProductApiResponseRequired.md)
 - [ProductResponseDataRequired](docs/ProductResponseDataRequired.md)
 - [ProductSku](docs/ProductSku.md)


## Documentation For Authorization


## ca_key

- **Type**: API key
- **API key parameter name**: x-ca-key
- **Location**: HTTP header


## ca_stage

- **Type**: API key
- **API key parameter name**: x-ca-stage
- **Location**: HTTP header


## Author

paul@samarkand.global


