import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::GroundStation::Config`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export interface CfnConfigProps {
    /**
     * `AWS::GroundStation::Config.ConfigData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-configdata
     */
    readonly configData: CfnConfig.ConfigDataProperty | cdk.IResolvable;
    /**
     * `AWS::GroundStation::Config.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-name
     */
    readonly name: string;
    /**
     * `AWS::GroundStation::Config.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare class CfnConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GroundStation::Config";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfig;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::GroundStation::Config.ConfigData`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-configdata
     */
    configData: CfnConfig.ConfigDataProperty | cdk.IResolvable;
    /**
     * `AWS::GroundStation::Config.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-name
     */
    name: string;
    /**
     * `AWS::GroundStation::Config.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html#cfn-groundstation-config-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::GroundStation::Config`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennadownlinkconfig.html
     */
    interface AntennaDownlinkConfigProperty {
        /**
         * `CfnConfig.AntennaDownlinkConfigProperty.SpectrumConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennadownlinkconfig.html#cfn-groundstation-config-antennadownlinkconfig-spectrumconfig
         */
        readonly spectrumConfig?: CfnConfig.SpectrumConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennadownlinkdemoddecodeconfig.html
     */
    interface AntennaDownlinkDemodDecodeConfigProperty {
        /**
         * `CfnConfig.AntennaDownlinkDemodDecodeConfigProperty.DecodeConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennadownlinkdemoddecodeconfig.html#cfn-groundstation-config-antennadownlinkdemoddecodeconfig-decodeconfig
         */
        readonly decodeConfig?: CfnConfig.DecodeConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.AntennaDownlinkDemodDecodeConfigProperty.DemodulationConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennadownlinkdemoddecodeconfig.html#cfn-groundstation-config-antennadownlinkdemoddecodeconfig-demodulationconfig
         */
        readonly demodulationConfig?: CfnConfig.DemodulationConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.AntennaDownlinkDemodDecodeConfigProperty.SpectrumConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennadownlinkdemoddecodeconfig.html#cfn-groundstation-config-antennadownlinkdemoddecodeconfig-spectrumconfig
         */
        readonly spectrumConfig?: CfnConfig.SpectrumConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennauplinkconfig.html
     */
    interface AntennaUplinkConfigProperty {
        /**
         * `CfnConfig.AntennaUplinkConfigProperty.SpectrumConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennauplinkconfig.html#cfn-groundstation-config-antennauplinkconfig-spectrumconfig
         */
        readonly spectrumConfig?: CfnConfig.UplinkSpectrumConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.AntennaUplinkConfigProperty.TargetEirp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennauplinkconfig.html#cfn-groundstation-config-antennauplinkconfig-targeteirp
         */
        readonly targetEirp?: CfnConfig.EirpProperty | cdk.IResolvable;
        /**
         * `CfnConfig.AntennaUplinkConfigProperty.TransmitDisabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-antennauplinkconfig.html#cfn-groundstation-config-antennauplinkconfig-transmitdisabled
         */
        readonly transmitDisabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html
     */
    interface ConfigDataProperty {
        /**
         * `CfnConfig.ConfigDataProperty.AntennaDownlinkConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-antennadownlinkconfig
         */
        readonly antennaDownlinkConfig?: CfnConfig.AntennaDownlinkConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.ConfigDataProperty.AntennaDownlinkDemodDecodeConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-antennadownlinkdemoddecodeconfig
         */
        readonly antennaDownlinkDemodDecodeConfig?: CfnConfig.AntennaDownlinkDemodDecodeConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.ConfigDataProperty.AntennaUplinkConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-antennauplinkconfig
         */
        readonly antennaUplinkConfig?: CfnConfig.AntennaUplinkConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.ConfigDataProperty.DataflowEndpointConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-dataflowendpointconfig
         */
        readonly dataflowEndpointConfig?: CfnConfig.DataflowEndpointConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.ConfigDataProperty.S3RecordingConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-s3recordingconfig
         */
        readonly s3RecordingConfig?: CfnConfig.S3RecordingConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.ConfigDataProperty.TrackingConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-trackingconfig
         */
        readonly trackingConfig?: CfnConfig.TrackingConfigProperty | cdk.IResolvable;
        /**
         * `CfnConfig.ConfigDataProperty.UplinkEchoConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-configdata.html#cfn-groundstation-config-configdata-uplinkechoconfig
         */
        readonly uplinkEchoConfig?: CfnConfig.UplinkEchoConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-dataflowendpointconfig.html
     */
    interface DataflowEndpointConfigProperty {
        /**
         * `CfnConfig.DataflowEndpointConfigProperty.DataflowEndpointName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-dataflowendpointconfig.html#cfn-groundstation-config-dataflowendpointconfig-dataflowendpointname
         */
        readonly dataflowEndpointName?: string;
        /**
         * `CfnConfig.DataflowEndpointConfigProperty.DataflowEndpointRegion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-dataflowendpointconfig.html#cfn-groundstation-config-dataflowendpointconfig-dataflowendpointregion
         */
        readonly dataflowEndpointRegion?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-decodeconfig.html
     */
    interface DecodeConfigProperty {
        /**
         * `CfnConfig.DecodeConfigProperty.UnvalidatedJSON`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-decodeconfig.html#cfn-groundstation-config-decodeconfig-unvalidatedjson
         */
        readonly unvalidatedJson?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-demodulationconfig.html
     */
    interface DemodulationConfigProperty {
        /**
         * `CfnConfig.DemodulationConfigProperty.UnvalidatedJSON`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-demodulationconfig.html#cfn-groundstation-config-demodulationconfig-unvalidatedjson
         */
        readonly unvalidatedJson?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-eirp.html
     */
    interface EirpProperty {
        /**
         * `CfnConfig.EirpProperty.Units`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-eirp.html#cfn-groundstation-config-eirp-units
         */
        readonly units?: string;
        /**
         * `CfnConfig.EirpProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-eirp.html#cfn-groundstation-config-eirp-value
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-frequency.html
     */
    interface FrequencyProperty {
        /**
         * `CfnConfig.FrequencyProperty.Units`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-frequency.html#cfn-groundstation-config-frequency-units
         */
        readonly units?: string;
        /**
         * `CfnConfig.FrequencyProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-frequency.html#cfn-groundstation-config-frequency-value
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-frequencybandwidth.html
     */
    interface FrequencyBandwidthProperty {
        /**
         * `CfnConfig.FrequencyBandwidthProperty.Units`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-frequencybandwidth.html#cfn-groundstation-config-frequencybandwidth-units
         */
        readonly units?: string;
        /**
         * `CfnConfig.FrequencyBandwidthProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-frequencybandwidth.html#cfn-groundstation-config-frequencybandwidth-value
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-s3recordingconfig.html
     */
    interface S3RecordingConfigProperty {
        /**
         * `CfnConfig.S3RecordingConfigProperty.BucketArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-s3recordingconfig.html#cfn-groundstation-config-s3recordingconfig-bucketarn
         */
        readonly bucketArn?: string;
        /**
         * `CfnConfig.S3RecordingConfigProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-s3recordingconfig.html#cfn-groundstation-config-s3recordingconfig-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnConfig.S3RecordingConfigProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-s3recordingconfig.html#cfn-groundstation-config-s3recordingconfig-rolearn
         */
        readonly roleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-spectrumconfig.html
     */
    interface SpectrumConfigProperty {
        /**
         * `CfnConfig.SpectrumConfigProperty.Bandwidth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-spectrumconfig.html#cfn-groundstation-config-spectrumconfig-bandwidth
         */
        readonly bandwidth?: CfnConfig.FrequencyBandwidthProperty | cdk.IResolvable;
        /**
         * `CfnConfig.SpectrumConfigProperty.CenterFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-spectrumconfig.html#cfn-groundstation-config-spectrumconfig-centerfrequency
         */
        readonly centerFrequency?: CfnConfig.FrequencyProperty | cdk.IResolvable;
        /**
         * `CfnConfig.SpectrumConfigProperty.Polarization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-spectrumconfig.html#cfn-groundstation-config-spectrumconfig-polarization
         */
        readonly polarization?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-trackingconfig.html
     */
    interface TrackingConfigProperty {
        /**
         * `CfnConfig.TrackingConfigProperty.Autotrack`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-trackingconfig.html#cfn-groundstation-config-trackingconfig-autotrack
         */
        readonly autotrack?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-uplinkechoconfig.html
     */
    interface UplinkEchoConfigProperty {
        /**
         * `CfnConfig.UplinkEchoConfigProperty.AntennaUplinkConfigArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-uplinkechoconfig.html#cfn-groundstation-config-uplinkechoconfig-antennauplinkconfigarn
         */
        readonly antennaUplinkConfigArn?: string;
        /**
         * `CfnConfig.UplinkEchoConfigProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-uplinkechoconfig.html#cfn-groundstation-config-uplinkechoconfig-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::Config`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::Config
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-config.html
 */
export declare namespace CfnConfig {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-uplinkspectrumconfig.html
     */
    interface UplinkSpectrumConfigProperty {
        /**
         * `CfnConfig.UplinkSpectrumConfigProperty.CenterFrequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-uplinkspectrumconfig.html#cfn-groundstation-config-uplinkspectrumconfig-centerfrequency
         */
        readonly centerFrequency?: CfnConfig.FrequencyProperty | cdk.IResolvable;
        /**
         * `CfnConfig.UplinkSpectrumConfigProperty.Polarization`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-config-uplinkspectrumconfig.html#cfn-groundstation-config-uplinkspectrumconfig-polarization
         */
        readonly polarization?: string;
    }
}
/**
 * Properties for defining a `AWS::GroundStation::DataflowEndpointGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html
 */
export interface CfnDataflowEndpointGroupProps {
    /**
     * `AWS::GroundStation::DataflowEndpointGroup.EndpointDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-endpointdetails
     */
    readonly endpointDetails: Array<CfnDataflowEndpointGroup.EndpointDetailsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GroundStation::DataflowEndpointGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::GroundStation::DataflowEndpointGroup`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::DataflowEndpointGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html
 */
export declare class CfnDataflowEndpointGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GroundStation::DataflowEndpointGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataflowEndpointGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::GroundStation::DataflowEndpointGroup.EndpointDetails`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-endpointdetails
     */
    endpointDetails: Array<CfnDataflowEndpointGroup.EndpointDetailsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GroundStation::DataflowEndpointGroup.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html#cfn-groundstation-dataflowendpointgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::GroundStation::DataflowEndpointGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataflowEndpointGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GroundStation::DataflowEndpointGroup`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::DataflowEndpointGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html
 */
export declare namespace CfnDataflowEndpointGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-dataflowendpoint.html
     */
    interface DataflowEndpointProperty {
        /**
         * `CfnDataflowEndpointGroup.DataflowEndpointProperty.Address`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-dataflowendpoint.html#cfn-groundstation-dataflowendpointgroup-dataflowendpoint-address
         */
        readonly address?: CfnDataflowEndpointGroup.SocketAddressProperty | cdk.IResolvable;
        /**
         * `CfnDataflowEndpointGroup.DataflowEndpointProperty.Mtu`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-dataflowendpoint.html#cfn-groundstation-dataflowendpointgroup-dataflowendpoint-mtu
         */
        readonly mtu?: number;
        /**
         * `CfnDataflowEndpointGroup.DataflowEndpointProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-dataflowendpoint.html#cfn-groundstation-dataflowendpointgroup-dataflowendpoint-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::DataflowEndpointGroup`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::DataflowEndpointGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html
 */
export declare namespace CfnDataflowEndpointGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-endpointdetails.html
     */
    interface EndpointDetailsProperty {
        /**
         * `CfnDataflowEndpointGroup.EndpointDetailsProperty.Endpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-endpointdetails.html#cfn-groundstation-dataflowendpointgroup-endpointdetails-endpoint
         */
        readonly endpoint?: CfnDataflowEndpointGroup.DataflowEndpointProperty | cdk.IResolvable;
        /**
         * `CfnDataflowEndpointGroup.EndpointDetailsProperty.SecurityDetails`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-endpointdetails.html#cfn-groundstation-dataflowendpointgroup-endpointdetails-securitydetails
         */
        readonly securityDetails?: CfnDataflowEndpointGroup.SecurityDetailsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GroundStation::DataflowEndpointGroup`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::DataflowEndpointGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html
 */
export declare namespace CfnDataflowEndpointGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-securitydetails.html
     */
    interface SecurityDetailsProperty {
        /**
         * `CfnDataflowEndpointGroup.SecurityDetailsProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-securitydetails.html#cfn-groundstation-dataflowendpointgroup-securitydetails-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnDataflowEndpointGroup.SecurityDetailsProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-securitydetails.html#cfn-groundstation-dataflowendpointgroup-securitydetails-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnDataflowEndpointGroup.SecurityDetailsProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-securitydetails.html#cfn-groundstation-dataflowendpointgroup-securitydetails-subnetids
         */
        readonly subnetIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::GroundStation::DataflowEndpointGroup`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::DataflowEndpointGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-dataflowendpointgroup.html
 */
export declare namespace CfnDataflowEndpointGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-socketaddress.html
     */
    interface SocketAddressProperty {
        /**
         * `CfnDataflowEndpointGroup.SocketAddressProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-socketaddress.html#cfn-groundstation-dataflowendpointgroup-socketaddress-name
         */
        readonly name?: string;
        /**
         * `CfnDataflowEndpointGroup.SocketAddressProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-dataflowendpointgroup-socketaddress.html#cfn-groundstation-dataflowendpointgroup-socketaddress-port
         */
        readonly port?: number;
    }
}
/**
 * Properties for defining a `AWS::GroundStation::MissionProfile`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html
 */
export interface CfnMissionProfileProps {
    /**
     * `AWS::GroundStation::MissionProfile.DataflowEdges`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-dataflowedges
     */
    readonly dataflowEdges: Array<CfnMissionProfile.DataflowEdgeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GroundStation::MissionProfile.MinimumViableContactDurationSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-minimumviablecontactdurationseconds
     */
    readonly minimumViableContactDurationSeconds: number;
    /**
     * `AWS::GroundStation::MissionProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-name
     */
    readonly name: string;
    /**
     * `AWS::GroundStation::MissionProfile.TrackingConfigArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-trackingconfigarn
     */
    readonly trackingConfigArn: string;
    /**
     * `AWS::GroundStation::MissionProfile.ContactPostPassDurationSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactpostpassdurationseconds
     */
    readonly contactPostPassDurationSeconds?: number;
    /**
     * `AWS::GroundStation::MissionProfile.ContactPrePassDurationSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactprepassdurationseconds
     */
    readonly contactPrePassDurationSeconds?: number;
    /**
     * `AWS::GroundStation::MissionProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::GroundStation::MissionProfile`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::MissionProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html
 */
export declare class CfnMissionProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GroundStation::MissionProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMissionProfile;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute Region
     */
    readonly attrRegion: string;
    /**
     * `AWS::GroundStation::MissionProfile.DataflowEdges`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-dataflowedges
     */
    dataflowEdges: Array<CfnMissionProfile.DataflowEdgeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GroundStation::MissionProfile.MinimumViableContactDurationSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-minimumviablecontactdurationseconds
     */
    minimumViableContactDurationSeconds: number;
    /**
     * `AWS::GroundStation::MissionProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-name
     */
    name: string;
    /**
     * `AWS::GroundStation::MissionProfile.TrackingConfigArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-trackingconfigarn
     */
    trackingConfigArn: string;
    /**
     * `AWS::GroundStation::MissionProfile.ContactPostPassDurationSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactpostpassdurationseconds
     */
    contactPostPassDurationSeconds: number | undefined;
    /**
     * `AWS::GroundStation::MissionProfile.ContactPrePassDurationSeconds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-contactprepassdurationseconds
     */
    contactPrePassDurationSeconds: number | undefined;
    /**
     * `AWS::GroundStation::MissionProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html#cfn-groundstation-missionprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::GroundStation::MissionProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMissionProfileProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GroundStation::MissionProfile`.
 *
 * @external
 * @cloudformationResource AWS::GroundStation::MissionProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-groundstation-missionprofile.html
 */
export declare namespace CfnMissionProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-missionprofile-dataflowedge.html
     */
    interface DataflowEdgeProperty {
        /**
         * `CfnMissionProfile.DataflowEdgeProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-missionprofile-dataflowedge.html#cfn-groundstation-missionprofile-dataflowedge-destination
         */
        readonly destination?: string;
        /**
         * `CfnMissionProfile.DataflowEdgeProperty.Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-groundstation-missionprofile-dataflowedge.html#cfn-groundstation-missionprofile-dataflowedge-source
         */
        readonly source?: string;
    }
}
