import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * CRUD operations for New Relic Dashboards via the NerdGraph API
 *
 * @schema CfnDashboardsProps
 */
export interface CfnDashboardsProps {
    /**
     * @schema CfnDashboardsProps#DashboardInput
     */
    readonly dashboardInput?: string;
    /**
     * @schema CfnDashboardsProps#ListQueryFilter
     */
    readonly listQueryFilter?: string;
    /**
     * @schema CfnDashboardsProps#Variables
     */
    readonly variables?: any;
    /**
     * @schema CfnDashboardsProps#Tags
     */
    readonly tags?: any;
}
/**
 * Converts an object of type 'CfnDashboardsProps' to JSON representation.
 */
export declare function toJson_CfnDashboardsProps(obj: CfnDashboardsProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `NewRelic::Observability::Dashboards`
 *
 * @cloudformationResource NewRelic::Observability::Dashboards
 * @stability external
 * @link https://github.com/newrelic-experimental/newrelic-cloudformation-resource-providers-dashboards
 */
export declare class CfnDashboards extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "NewRelic::Observability::Dashboards";
    /**
     * Resource props.
     */
    readonly props: CfnDashboardsProps;
    /**
     * Attribute `NewRelic::Observability::Dashboards.Guid`
     * @link https://github.com/newrelic-experimental/newrelic-cloudformation-resource-providers-dashboards
     */
    readonly attrGuid: string;
    /**
     * Create a new `NewRelic::Observability::Dashboards`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDashboardsProps);
}
