import setuptools

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

PROJECT_NAME = "oneNeuron"
USER_NAME = "kkc11"

setuptools.setup(
    name=f"{PROJECT_NAME}-{USER_NAME}",
    version="0.0.2",
    author="kkc",
    author_email="kkchaudhary11@gmail.com",
    description="it is a implemenation of preceptron",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/kkchaudhary11/oneNeuron_CD",
    project_urls={
        "Bug Tracker": f"https://github.com/{PROJECT_NAME}/{USER_NAME}/issues",
    },
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    package_dir={"": "src"},
    packages=setuptools.find_packages(where="src"),
    python_requires=">=3.7",
    install_requires=[
        "numpy"
        "tqdm"
        ]
)
