from pathlib import Path

META_LIST = [
    {
        "command_name": "crc32",
        "display_name": "CRC32",
        "package": "gethash.wrappers.crc32",
        "hasher": "CRC32",
    },
    {
        "command_name": "md5",
        "display_name": "MD5",
        "package": "hashlib",
        "hasher": "md5",
    },
    {
        "command_name": "sha1",
        "display_name": "SHA1",
        "package": "hashlib",
        "hasher": "sha1",
    },
    {
        "command_name": "sha256",
        "display_name": "SHA256",
        "package": "hashlib",
        "hasher": "sha256",
    },
    {
        "command_name": "sha512",
        "display_name": "SHA512",
        "package": "hashlib",
        "hasher": "sha512",
    },
    {
        "command_name": "sha3-256",
        "display_name": "SHA3-256",
        "package": "hashlib",
        "hasher": "sha3_256",
    },
    {
        "command_name": "sha3-512",
        "display_name": "SHA3-512",
        "package": "hashlib",
        "hasher": "sha3_512",
    },
    {
        "command_name": "blake2b",
        "display_name": "BLAKE2b",
        "package": "hashlib",
        "hasher": "blake2b",
    },
    {
        "command_name": "blake2s",
        "display_name": "BLAKE2s",
        "package": "hashlib",
        "hasher": "blake2s",
    },
]

TEMPLATE = """\
# This file is automatically generated. Do not edit it.
from typing import Any

from gethash.script import gethashcli, script_main

META = {meta}


@gethashcli(**META)
def main(files: tuple[str, ...], **kwargs: Any) -> None:
    \"""Generate or check {display_name}.\"""

    from {package} import {hasher} as H

    script_main(H(), files, **kwargs)


if __name__ == "__main__":
    main()
"""


def main() -> None:
    cli_dir = Path(__file__).parent
    for meta in META_LIST:
        command_name = meta["command_name"]
        display_name = meta["display_name"]
        package = meta["package"]
        hasher = meta["hasher"]
        code = TEMPLATE.format(meta=str(meta), display_name=display_name, package=package, hasher=hasher)
        name = command_name.replace("-", "_") + ".py"
        path = cli_dir / name
        path.write_text(code)


if __name__ == "__main__":
    main()
