/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.optimization.sls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Function;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.probabilistic.ClusRuleProbabilisticRuleSetInduce;
import si.ijs.kt.clus.algo.rules.probabilistic.Parallel;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;

public class OptSmoothLocalSearch {
    int m_maxRulesNb;
    Random m_randGen;
    ClusStatManager statManager;
    HashSet<Integer> A;
    ClusRun m_mainClusRun;
    ClusRuleProbabilisticRuleSetInduce clusRuleProbabilisticRuleSetInduce;
    double[] estimates;
    double errorMargin;
    ClusRuleSet initialRuleSet;
    Function<ClusRuleSet, Double> objectiveFunction;
    ArrayList<Integer> m_indices = new ArrayList();

    public OptSmoothLocalSearch(Integer m_maxRulesNb, Random m_randGen, ClusStatManager statManager, ClusRun m_mainClusRun, ClusRuleProbabilisticRuleSetInduce clusRuleProbabilisticRuleSetInduce) {
        this.m_maxRulesNb = m_maxRulesNb;
        this.m_randGen = m_randGen;
        this.statManager = statManager;
        this.m_mainClusRun = m_mainClusRun;
        this.clusRuleProbabilisticRuleSetInduce = clusRuleProbabilisticRuleSetInduce;
    }

    public ClusRuleSet SmoothLocalSearch(ClusRuleSet initialRuleSet, double delta, double deltaPrime, Function<ClusRuleSet, Double> objectiveFunction) {
        this.initialRuleSet = initialRuleSet;
        this.objectiveFunction = objectiveFunction;
        this.m_indices = new ArrayList();
        for (int i = 0; i < initialRuleSet.getModelSize(); ++i) {
            this.m_indices.add(i);
        }
        this.A = new HashSet();
        this.m_maxRulesNb = Math.min(this.m_indices.size(), this.m_maxRulesNb);
        ClusRuleSet rndSet = this.randomSampleWithBias(0.5);
        double OPT = objectiveFunction.apply(rndSet);
        double probabilityBiased = (1.0 + delta) / 2.0;
        double probabilityPrimeBiased = (1.0 + deltaPrime) / 2.0;
        this.errorMargin = 1.0 / Math.pow(initialRuleSet.getModelSize(), 2.0) * OPT;
        this.estimates = new double[initialRuleSet.getModelSize()];
        boolean dowork = true;
        while (dowork) {
            this.calculateEstimatesParallel(probabilityBiased);
            if (this.findBiasedRules() || this.removeBadRules()) continue;
            dowork = false;
        }
        rndSet = this.randomSampleWithBias(probabilityPrimeBiased);
        return rndSet;
    }

    private boolean removeBadRules() {
        for (int rule : this.A) {
            if (!(this.estimates[rule] < -2.0 * this.errorMargin)) continue;
            this.A.remove(rule);
            return true;
        }
        return false;
    }

    private boolean findBiasedRules() {
        for (int rule = 0; rule < this.initialRuleSet.getModelSize(); ++rule) {
            if (this.A.contains(rule) || !(this.estimates[rule] > 2.0 * this.errorMargin)) continue;
            this.A.add(rule);
            return true;
        }
        return false;
    }

    private void calculateEstimates(double probabilityBiased) {
        for (int rule = 0; rule < this.initialRuleSet.getModelSize(); ++rule) {
            ClusRule ruleToCheck = this.initialRuleSet.getRule(rule);
            this.estimates[rule] = this.getEstimate(ruleToCheck, probabilityBiased);
        }
    }

    private void calculateEstimatesParallel(double probabilityBiased) {
        ArrayList<Integer> elems = new ArrayList<Integer>();
        for (int i = 0; i < this.initialRuleSet.getModelSize(); ++i) {
            elems.add(i);
        }
        final double prob = probabilityBiased;
        Parallel.For(elems, new Parallel.Operation<Integer>(){

            @Override
            public void perform(Integer rule) {
                ClusRule ruleToCheck = OptSmoothLocalSearch.this.initialRuleSet.getRule(rule);
                OptSmoothLocalSearch.this.estimates[rule.intValue()] = OptSmoothLocalSearch.this.getEstimate(ruleToCheck, prob);
            }
        });
    }

    ClusRuleSet randomSampleWithBias(double probabilityBiased) {
        ClusRuleSet returnSet = new ClusRuleSet(this.statManager);
        double probA = 1.0 - probabilityBiased;
        for (int index = 0; index < this.m_maxRulesNb; ++index) {
            int rule = this.m_indices.get(index);
            double prob = this.m_randGen.nextDouble();
            if (!(this.A.contains(rule) && prob >= probA) && (this.A.contains(rule) || !(prob >= probabilityBiased))) continue;
            returnSet.getRules().add(this.initialRuleSet.getRule(rule));
        }
        return returnSet;
    }

    ClusRuleSet randomSampleWithoutBias(ClusRuleSet rules) {
        ClusRuleSet returnSet = new ClusRuleSet(this.statManager);
        for (int rule = 0; rule < rules.getModelSize(); ++rule) {
            if (!(this.m_randGen.nextDouble() >= 0.5)) continue;
            returnSet.getRules().add(rules.getRule(rule));
        }
        return returnSet;
    }

    double getEstimate(ClusRule ruleToCheck, double probabilityBiased) {
        ArrayList<Double> differenceValuesArray = new ArrayList<Double>(100);
        double sum = 0.0;
        double tmp = 0.0;
        double mean = 0.0;
        double error = this.errorMargin;
        double counter = 0.0;
        boolean numberOfIterationsBeforeCalculation = true;
        while (error >= this.errorMargin) {
            counter += 1.0;
            ClusRuleSet rndSet = this.randomSampleWithBias(probabilityBiased);
            ClusRuleSet setWithRuleToCheck = rndSet.cloneRuleSetNonUnique();
            ClusRuleSet setWithoutRuleToCheck = rndSet.cloneRuleSetNonUnique();
            setWithRuleToCheck.add(ruleToCheck);
            setWithoutRuleToCheck.remove(ruleToCheck);
            double tmpSetEstimate1 = this.objectiveFunction.apply(setWithRuleToCheck);
            double tmpSetEstimate2 = this.objectiveFunction.apply(setWithoutRuleToCheck);
            tmp = tmpSetEstimate1 - tmpSetEstimate2;
            sum += tmp;
            differenceValuesArray.add(tmp);
            if (counter % (double)numberOfIterationsBeforeCalculation != 0.0) continue;
            mean = sum / counter;
            tmp = 0.0;
            Iterator iterator = differenceValuesArray.iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                tmp += Math.pow(mean - d, 2.0);
            }
            tmp = Math.sqrt(1.0 / (counter - 1.0) * tmp);
            error = tmp / Math.sqrt(counter);
        }
        return mean;
    }
}

