/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.optimization.de;

import java.util.ArrayList;
import java.util.Random;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.util.tools.optimization.OptimizationProblem;

public class DEProblem
extends OptimizationProblem {
    private ArrayList<Double> m_VarMin = new ArrayList(this.getNumVar());
    private ArrayList<Double> m_VarMax = new ArrayList(this.getNumVar());

    public DEProblem(ClusStatManager stat_mgr, OptimizationProblem.OptimizationParameter optInfo, ClusRuleSet rset) {
        super(stat_mgr, optInfo);
        for (int i = 0; i < this.getNumVar(); ++i) {
            this.m_VarMin.add(new Double(0.0));
            this.m_VarMax.add(new Double(1.0));
        }
    }

    public ArrayList<Double> getRandVector(Random rand) {
        ArrayList<Double> result = new ArrayList<Double>(this.getNumVar());
        for (int i = 0; i < this.getNumVar(); ++i) {
            result.add(new Double(this.getRandValueInRange(rand, i)));
        }
        return result;
    }

    public double getRandValueInRange(Random rand, int indexOfValue) {
        return this.m_VarMin.get(indexOfValue) + (this.m_VarMax.get(indexOfValue) - this.m_VarMin.get(indexOfValue)) * rand.nextDouble();
    }

    public ArrayList<Double> getRoundVector(ArrayList<Double> genes) {
        ArrayList<Double> result = new ArrayList<Double>(this.getNumVar());
        for (int i = 0; i < this.getNumVar(); ++i) {
            if (genes.get(i) >= this.m_VarMax.get(i)) {
                result.add(this.m_VarMax.get(i));
                continue;
            }
            if (genes.get(i) <= this.m_VarMin.get(i)) {
                result.add(this.m_VarMin.get(i));
                continue;
            }
            result.add(genes.get(i));
        }
        return result;
    }
}

