/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.optimization.de;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.tools.optimization.OptimizationAlgorithm;
import si.ijs.kt.clus.util.tools.optimization.OptimizationProblem;
import si.ijs.kt.clus.util.tools.optimization.de.DEIndividual;
import si.ijs.kt.clus.util.tools.optimization.de.DEPopulation;
import si.ijs.kt.clus.util.tools.optimization.de.DEProblem;

public class DEAlgorithm
extends OptimizationAlgorithm {
    private DEProblem m_DeProbl;
    private DEPopulation m_Pop;
    private DEIndividual m_Best;

    public DEAlgorithm(ClusStatManager stat_mgr, OptimizationProblem.OptimizationParameter dataInformation, ClusRuleSet rset) {
        super(stat_mgr);
        this.m_DeProbl = new DEProblem(stat_mgr, dataInformation, rset);
        this.m_Pop = new DEPopulation(stat_mgr, this.m_DeProbl);
    }

    @Override
    public ArrayList<Double> optimize() {
        System.out.print("\nDifferential evolution: Optimizing rule weights (" + this.getSettings().getRules().getOptDENumEval() + ") ");
        try {
            PrintWriter wrt_log = new PrintWriter(new OutputStreamWriter(new FileOutputStream("evol.log")));
            this.m_Pop.createFirstPop();
            int num_eval = this.m_Pop.evaluatePop(0);
            this.m_Best = new DEIndividual();
            this.m_Best.copy(this.m_Pop.m_Inds.get(0));
            for (int i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
                this.checkIfBest(this.m_Pop.m_Inds.get(i));
                this.OutputLog(this.m_Pop.m_Inds.get(i), i, wrt_log);
            }
            this.OutputPop();
            while (num_eval < this.getSettings().getRules().getOptDENumEval()) {
                System.out.print(".");
                this.m_Pop.sortPopRandom();
                DEIndividual candidate = new DEIndividual();
                for (int i = 0; i < this.getSettings().getRules().getOptDEPopSize(); ++i) {
                    candidate.setGenes(this.m_Pop.getCandidate(i));
                    num_eval = candidate.evaluate(this.m_DeProbl, num_eval);
                    this.checkIfBest(this.m_Pop.m_Inds.get(i));
                    this.OutputLog(candidate, num_eval, wrt_log);
                    if (!(candidate.m_Fitness < this.m_Pop.m_Inds.get((int)i).m_Fitness)) continue;
                    this.m_Pop.m_Inds.get(i).copy(candidate);
                }
            }
            wrt_log.close();
            ClusLogger.info(" done!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.m_Best.getGenes();
    }

    public void OutputPop() throws IOException {
    }

    public void checkIfBest(DEIndividual ind) {
        if (this.m_Best.m_Fitness > ind.m_Fitness) {
            this.m_Best.copy(ind);
        }
    }

    public void OutputLog(DEIndividual ind, int index, PrintWriter wrt) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        wrt.print("" + fr.format(index));
        wrt.print("\t");
        wrt.print("" + fr.format(this.m_Best.m_Fitness));
        wrt.print("\t");
        wrt.print(ind.getIndString());
        wrt.print("\n");
    }
}

