/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.optimization;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.RuleNormalization;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.tools.optimization.ImplicitLinearTerms;
import si.ijs.kt.clus.util.tools.optimization.gd.GDProblem;

public class OptimizationProblem {
    protected static final double INVALID_PREDICTION = Double.NEGATIVE_INFINITY;
    private int m_NumVar;
    private RulePred[] m_RulePred;
    private double[][][][] m_BaseFuncPred;
    private ImplicitLinearTerms m_LinTermMemSavePred = null;
    private TrueValues[] m_TrueVal;
    private ClusStatManager m_StatMgr;
    private boolean m_ClssTask;
    private double[] m_TargetAvg;
    private double[] m_TargetNormFactor;
    boolean m_saveMemoryLinears;

    public OptimizationProblem(ClusStatManager stat_mgr, OptimizationParameter optInfo) {
        this.m_StatMgr = stat_mgr;
        this.m_saveMemoryLinears = this.getSettings().getRules().getOptAddLinearTerms().equals((Object)SettingsRules.OptimizationGDAddLinearTerms.YesSaveMemory);
        if (this.m_saveMemoryLinears) {
            int nbOfTargetAtts = this.m_StatMgr.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target).length;
            int nbOfDescrAtts = this.m_StatMgr.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive).length;
            this.m_NumVar = optInfo.m_baseFuncPredictions.length + optInfo.m_rulePredictions.length + nbOfTargetAtts * nbOfDescrAtts;
        } else {
            this.m_NumVar = optInfo.m_baseFuncPredictions.length + optInfo.m_rulePredictions.length;
        }
        this.m_LinTermMemSavePred = optInfo.m_implicitLinearTerms;
        this.m_BaseFuncPred = optInfo.m_baseFuncPredictions;
        this.m_RulePred = optInfo.m_rulePredictions;
        this.m_TrueVal = optInfo.m_trueValues;
        if (stat_mgr.getTargetMode() != ClusStatManager.Mode.REGRESSION && stat_mgr.getTargetMode() != ClusStatManager.Mode.CLASSIFY) {
            System.err.println("Weight optimization: Mixed types of targets (reg/clas) not implemented. Assuming regression.\n ");
        }
        boolean bl = this.m_ClssTask = stat_mgr.getTargetMode() == ClusStatManager.Mode.CLASSIFY;
        if (!this.m_ClssTask) {
            this.m_TargetAvg = new double[this.getNbOfTargets()];
            if (this.getSettings().getRules().isOptNormalization()) {
                this.m_TargetNormFactor = OptimizationProblem.initNormFactors(this.getNbOfTargets(), this.getSettings());
                if (!this.getSettings().getRules().getOptNormalization().equals((Object)SettingsRules.OptimizationNormalization.OnlyScaling)) {
                    this.m_TargetAvg = OptimizationProblem.initMeans(this.getNbOfTargets());
                }
            }
        }
    }

    public static void splitDataIntoValAndTrainSet(ClusStatManager stat_mgr, OptimizationParameter origData, OptimizationParameter valData, OptimizationParameter trainData) {
        int iRule;
        Settings set = stat_mgr.getSettings();
        int nbRows = origData.m_trueValues.length;
        int nbDataTest = (int)Math.ceil((double)nbRows * set.getRules().getOptGDEarlyStopAmount());
        Random randGen = new Random(0L);
        boolean[] selectedInstances = new boolean[nbRows];
        for (int iTestSetInstance = 0; iTestSetInstance < nbDataTest; ++iTestSetInstance) {
            int newIndex = randGen.nextInt(nbRows - iTestSetInstance);
            int iNewTestInstance = 0;
            int indexOfUnUsedInstance = 0;
            while (indexOfUnUsedInstance < newIndex) {
                if (!selectedInstances[iNewTestInstance]) {
                    ++indexOfUnUsedInstance;
                }
                ++iNewTestInstance;
            }
            while (selectedInstances[iNewTestInstance]) {
                ++iNewTestInstance;
            }
            selectedInstances[iNewTestInstance] = true;
            valData.m_trueValues[iTestSetInstance] = origData.m_trueValues[iNewTestInstance];
            origData.m_trueValues[iNewTestInstance] = null;
            for (int iNonRule = 0; iNonRule < origData.m_baseFuncPredictions.length; ++iNonRule) {
                valData.m_baseFuncPredictions[iNonRule][iTestSetInstance] = origData.m_baseFuncPredictions[iNonRule][iNewTestInstance];
                origData.m_baseFuncPredictions[iNonRule][iNewTestInstance] = null;
            }
            for (iRule = 0; iRule < origData.m_rulePredictions.length; ++iRule) {
                if (!origData.m_rulePredictions[iRule].m_cover.get(iNewTestInstance)) continue;
                valData.m_rulePredictions[iRule].m_cover.set(iTestSetInstance);
            }
        }
        int iInstanceRestIndex = 0;
        int nbOfInstances = nbRows;
        for (int iInstance = 0; iInstance < nbOfInstances; ++iInstance) {
            if (selectedInstances[iInstance]) continue;
            trainData.m_trueValues[iInstanceRestIndex] = origData.m_trueValues[iInstance];
            for (iRule = 0; iRule < origData.m_baseFuncPredictions.length; ++iRule) {
                trainData.m_baseFuncPredictions[iRule][iInstanceRestIndex] = origData.m_baseFuncPredictions[iRule][iInstance];
            }
            for (iRule = 0; iRule < origData.m_rulePredictions.length; ++iRule) {
                if (!origData.m_rulePredictions[iRule].m_cover.get(iInstance)) continue;
                trainData.m_rulePredictions[iRule].m_cover.set(iInstanceRestIndex);
            }
            ++iInstanceRestIndex;
        }
        for (int iRule2 = 0; iRule2 < origData.m_rulePredictions.length; ++iRule2) {
            trainData.m_rulePredictions[iRule2].m_prediction = origData.m_rulePredictions[iRule2].m_prediction;
            valData.m_rulePredictions[iRule2].m_prediction = origData.m_rulePredictions[iRule2].m_prediction;
        }
        if (iInstanceRestIndex != trainData.m_trueValues.length) {
            System.err.println("GDProbl error. Wrong amount of early stop data added");
            System.exit(1);
        }
        set.getRules().setOptRegPar(0.0);
        set.getRules().setOptNbZeroesPar(0.0);
    }

    public final double calcFitness(ArrayList<Double> genes, ClusRuleSet rset) {
        return this.calcFitnessForTarget(genes, -1, rset);
    }

    public double calcFitnessForTarget(ArrayList<Double> genes, int iFitnessTarget, ClusRuleSet rset) {
        ClusStatistic tar_stat = this.getTargetStat();
        int nb_rows = this.getNbOfInstances();
        int nb_covered = 0;
        int nb_targets = tar_stat.getNbAttributes();
        int indFirstTarget = 0;
        int indLastTarget = tar_stat.getNbAttributes() - 1;
        if (iFitnessTarget != -1) {
            indFirstTarget = iFitnessTarget;
            indLastTarget = iFitnessTarget;
        }
        int[] nb_values = new int[nb_targets];
        for (int iTarget = indFirstTarget; iTarget <= indLastTarget; ++iTarget) {
            nb_values[iTarget] = this.isClassifTask() ? ((ClassificationStat)tar_stat).getAttribute(iTarget).getNbValues() : 1;
        }
        double[][] pred = new double[nb_rows][nb_targets];
        for (int iInstance = 0; iInstance < nb_rows; ++iInstance) {
            double[][] pred_sum = new double[nb_targets][];
            for (int iTarget = indFirstTarget; iTarget <= indLastTarget; ++iTarget) {
                pred_sum[iTarget] = new double[nb_values[iTarget]];
                if (this.isClassifTask()) {
                    pred[iInstance][iTarget] = Double.NEGATIVE_INFINITY;
                    for (int iValue = 0; iValue < nb_values[iTarget]; ++iValue) {
                        pred_sum[iTarget][iValue] = Double.NEGATIVE_INFINITY;
                    }
                    continue;
                }
                pred[iInstance][iTarget] = 0.0;
                pred_sum[iTarget][0] = 0.0;
            }
            boolean covered = false;
            for (int iRule = 0; iRule < this.getNumVar(); ++iRule) {
                if (genes.get(iRule) == 0.0 || !this.isCovered(iRule, iInstance)) continue;
                for (int iTarget = indFirstTarget; iTarget <= indLastTarget; ++iTarget) {
                    for (int iClass = 0; iClass < nb_values[iTarget]; ++iClass) {
                        double px = this.getPredictionsWhenCovered(iRule, iInstance, iTarget, iClass);
                        covered = true;
                        if (Double.isNaN(px)) continue;
                        double[] dArray = pred_sum[iTarget];
                        int n = iClass;
                        dArray[n] = dArray[n] + genes.get(iRule) * px;
                    }
                }
            }
            pred[iInstance] = this.isClassifTask() ? this.predictClass(pred_sum) : this.predictRegression(pred_sum);
            if (!covered) continue;
            ++nb_covered;
        }
        double loss = 0.0;
        if (this.isClassifTask()) {
            if (!this.getSettings().getRules().getOptDELossFunction().equals((Object)SettingsRules.OptimizationLossFunction.ZeroOneError)) {
                try {
                    throw new Exception("DE optimization task is for classification, but the chosen loss is mainly for regression. Use OptDELossFunction = 01Error to correct this.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    loss = this.loss(pred, iFitnessTarget);
                }
            } else {
                loss = this.loss(pred, iFitnessTarget) * (double)nb_rows / (double)nb_covered;
            }
        } else {
            loss = this.loss(pred, iFitnessTarget);
        }
        double reg_penalty = 0.0;
        if (this.getSettings().getRules().getOptRegPar() != 0.0) {
            reg_penalty = this.getSettings().getRules().getOptRegPar() * this.regularization(genes);
        }
        double nbOfZeroes_penalty = 0.0;
        if (this.getSettings().getRules().getOptNbZeroesPar() != 0.0) {
            nbOfZeroes_penalty = this.getSettings().getRules().getOptNbZeroesPar() * (double)this.returnNbNonZeroes(genes);
        }
        return loss + reg_penalty + nbOfZeroes_penalty;
    }

    private int returnNbNonZeroes(ArrayList<Double> genes) {
        int nbNonZeroes = 0;
        for (int j = 0; j < genes.size(); ++j) {
            if (genes.get(j) == 0.0) continue;
            ++nbNonZeroes;
        }
        return nbNonZeroes;
    }

    private double[] predictRegression(double[][] predictionSums) {
        int nbOfTargets = predictionSums.length;
        double[] prediction = new double[nbOfTargets];
        for (int iTarget = 0; iTarget < nbOfTargets; ++iTarget) {
            if (predictionSums[iTarget] == null) continue;
            prediction[iTarget] = predictionSums[iTarget][0];
        }
        return prediction;
    }

    protected double[] predictClass(double[][] predictionSums) {
        int nbOfTargets = predictionSums.length;
        double[] prediction = new double[nbOfTargets];
        for (int iTarget = 0; iTarget < nbOfTargets; ++iTarget) {
            double max = 0.0;
            int iMaxClass = 0;
            for (int iClass = 0; iClass < predictionSums[iTarget].length; ++iClass) {
                if (!(predictionSums[iTarget][iClass] > max)) continue;
                iMaxClass = iClass;
                max = predictionSums[iTarget][iClass];
            }
            prediction[iTarget] = iMaxClass;
        }
        return prediction;
    }

    protected double loss(double[][] prediction, int iTarget) {
        double loss = 0.0;
        switch (this.getSettings().getRules().getOptDELossFunction()) {
            case ZeroOneError: {
                if (iTarget != -1) {
                    System.err.println("Loss over single target implemented only for squared loss!");
                }
                loss = this.loss01(this.getTrueValues(), prediction);
                break;
            }
            case RRMSE: {
                if (iTarget != -1) {
                    System.err.println("Loss over single target implemented only for squared loss!");
                }
                loss = this.lossRRMSE(this.getTrueValues(), prediction);
                break;
            }
            case Huber: {
                if (iTarget != -1) {
                    System.err.println("Loss over single target implemented only for squared loss!");
                }
                loss = this.lossHuber(this.getTrueValues(), prediction);
                break;
            }
            default: {
                loss = this.lossSquared(prediction, iTarget);
            }
        }
        return loss;
    }

    private double lossSquared(double[][] prediction, int indTarget) {
        double loss = 0.0;
        int numberOfInstances = prediction.length;
        if (indTarget != -1) {
            for (int iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                loss += Math.pow(this.getTrueValue(iInstance, indTarget) - prediction[iInstance][indTarget], 2.0);
            }
        } else {
            int numberOfTargets = prediction[0].length;
            for (int jTarget = 0; jTarget < numberOfTargets; ++jTarget) {
                double attributeLoss = 0.0;
                for (int iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                    attributeLoss += Math.pow(this.getTrueValue(iInstance, jTarget) - prediction[iInstance][jTarget], 2.0);
                }
                if (this.getSettings().getRules().isOptNormalization()) {
                    attributeLoss /= this.getNormFactor(jTarget);
                }
                loss += 1.0 / (2.0 * (double)numberOfTargets) * attributeLoss;
            }
        }
        return loss / (double)numberOfInstances;
    }

    private double lossRRMSE(TrueValues[] trueValue, double[][] prediction) {
        double loss = 0.0;
        int numberOfInstances = prediction.length;
        int numberOfTargets = prediction[0].length;
        for (int jTarget = 0; jTarget < numberOfTargets; ++jTarget) {
            int iInstance;
            double attributeLoss = 0.0;
            double attribVariance = 0.0;
            double attribMean = 0.0;
            for (iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                attribMean += trueValue[iInstance].m_targets[jTarget];
            }
            attribMean /= (double)numberOfInstances;
            for (iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                attributeLoss += Math.pow(prediction[iInstance][jTarget] - trueValue[iInstance].m_targets[jTarget], 2.0);
                attribVariance += Math.pow(attribMean - trueValue[iInstance].m_targets[jTarget], 2.0);
            }
            loss += 1.0 / (double)numberOfTargets * Math.sqrt(attributeLoss / attribVariance);
        }
        return loss / (double)numberOfInstances;
    }

    private double lossHuber(TrueValues[] trueValue, double[][] prediction) {
        double loss = 0.0;
        int numberOfInstances = prediction.length;
        if (numberOfInstances == 0) {
            return 0.0;
        }
        int numberOfTargets = prediction[0].length;
        double[] deltas = this.computeHuberDeltas(trueValue, prediction);
        for (int jTarget = 0; jTarget < numberOfTargets; ++jTarget) {
            double attributeLoss = 0.0;
            for (int iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                if (Math.abs(trueValue[iInstance].m_targets[jTarget] - prediction[iInstance][jTarget]) < deltas[jTarget]) {
                    attributeLoss += Math.pow(trueValue[iInstance].m_targets[jTarget] - prediction[iInstance][jTarget], 2.0);
                    continue;
                }
                attributeLoss += deltas[jTarget] * (Math.abs(trueValue[iInstance].m_targets[jTarget] - prediction[iInstance][jTarget]) - deltas[jTarget] / 2.0);
            }
            loss += 1.0 / (double)numberOfTargets * attributeLoss;
        }
        return loss / (double)numberOfInstances;
    }

    private double[] computeHuberDeltas(TrueValues[] trueValues, double[][] predictions) {
        int numberOfInstances = trueValues.length;
        int numberOfTargets = trueValues[0].m_targets.length;
        double alpha = this.getSettings().getRules().getOptHuberAlpha();
        double[] deltas = new double[numberOfTargets];
        double[] targetDistances = new double[numberOfInstances];
        for (int jTarget = 0; jTarget < numberOfTargets; ++jTarget) {
            for (int iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                targetDistances[iInstance] = Math.abs(trueValues[iInstance].m_targets[jTarget] - predictions[iInstance][jTarget]);
            }
            Arrays.sort(targetDistances);
            deltas[jTarget] = targetDistances[(int)Math.floor((double)numberOfInstances * alpha)];
        }
        return deltas;
    }

    private double loss01(TrueValues[] trueValue, double[][] prediction) {
        int accuracy = 0;
        int numberOfInstances = prediction.length;
        int numberOfTargets = prediction[0].length;
        for (int jTarget = 0; jTarget < numberOfTargets; ++jTarget) {
            for (int iInstance = 0; iInstance < numberOfInstances; ++iInstance) {
                if (trueValue[iInstance].m_targets[jTarget] != prediction[iInstance][jTarget]) continue;
                ++accuracy;
            }
        }
        return 1.0 - (double)accuracy / (double)(numberOfInstances * numberOfTargets);
    }

    protected double regularization(ArrayList<Double> genes) {
        double reg_penalty = 0.0;
        for (int j = 0; j < genes.size(); ++j) {
            reg_penalty += Math.pow(Math.abs(genes.get(j)), this.getSettings().getRules().getOptDERegulPower());
        }
        return reg_penalty;
    }

    public final int getNumVar() {
        return this.m_NumVar;
    }

    protected final Settings getSettings() {
        return this.m_StatMgr.getSettings();
    }

    protected final ClusStatistic getTargetStat() {
        return this.m_StatMgr.getStatistic(ClusAttrType.AttributeUseType.Target);
    }

    protected final boolean isCovered(int iRule, int iInstance) {
        if (iRule >= this.m_RulePred.length) {
            return this.m_saveMemoryLinears ? true : !Double.isNaN(this.m_BaseFuncPred[iRule - this.m_RulePred.length][iInstance][0][0]);
        }
        return this.m_RulePred[iRule].m_cover.get(iInstance);
    }

    protected final double getPredictionsWhenCovered(int iRule, int iInstance, int iTarget, int iClass) {
        if (!this.isRuleTerm(iRule)) {
            if (this.m_saveMemoryLinears) {
                return this.m_LinTermMemSavePred.predict(iRule - this.m_RulePred.length, this.m_TrueVal[iInstance].m_dataExample, iTarget, this.m_RulePred[0].m_prediction.length);
            }
            return this.m_BaseFuncPred[iRule - this.m_RulePred.length][iInstance][iTarget][iClass];
        }
        return this.m_RulePred[iRule].m_prediction[iTarget][iClass];
    }

    protected final boolean isRuleTerm(int index) {
        return index < this.m_RulePred.length;
    }

    protected final double getPredictionsWhenCovered(int iRule, int iInstance, int iTarget) {
        return this.getPredictionsWhenCovered(iRule, iInstance, iTarget, 0);
    }

    protected final double getTrueValue(int iInstance, int iTarget) {
        return this.m_TrueVal[iInstance].m_targets[iTarget] - this.getMean(iTarget);
    }

    private final TrueValues[] getTrueValues() {
        return this.m_TrueVal;
    }

    public final boolean isClassifTask() {
        return this.m_ClssTask;
    }

    protected final int getNbOfInstances() {
        return this.m_TrueVal.length;
    }

    protected int getNbOfTargets() {
        return this.getTargetStat().getNbAttributes();
    }

    protected final void changeData(OptimizationParameter newData) {
        this.m_BaseFuncPred = newData.m_baseFuncPredictions;
        this.m_RulePred = newData.m_rulePredictions;
        this.m_TrueVal = newData.m_trueValues;
    }

    protected final boolean isValidValue(double pred) {
        return !Double.isInfinite(pred) && !Double.isNaN(pred);
    }

    public static double[] initMeans(int nbTargs) {
        double[] means = new double[nbTargs];
        for (int iTarget = 0; iTarget < nbTargs; ++iTarget) {
            means[iTarget] = RuleNormalization.getTargMean(iTarget);
        }
        return means;
    }

    public static double[] initNormFactors(int nbTargs, Settings sett) {
        double[] scaleFactor = new double[nbTargs];
        for (int iTarget = 0; iTarget < nbTargs; ++iTarget) {
            scaleFactor[iTarget] = sett.getRules().getOptNormalization().equals((Object)SettingsRules.OptimizationNormalization.YesVariance) ? Math.pow(RuleNormalization.getTargStdDev(iTarget), 4.0) : 4.0 * Math.pow(RuleNormalization.getTargStdDev(iTarget), 2.0);
        }
        return scaleFactor;
    }

    protected final double getNormFactor(int iTarget) {
        return this.m_TargetNormFactor[iTarget];
    }

    protected final double getMean(int iAttr) {
        return this.m_TargetAvg[iAttr];
    }

    protected final BitSet getRuleCovers(int iRule) {
        return this.m_RulePred[iRule].m_cover;
    }

    protected final int getRuleNextCovered(int iRule, int iFromIndex) {
        return this.m_RulePred[iRule].m_cover.nextSetBit(iFromIndex);
    }

    protected final int getLinTargetDim(int iLinTerm) {
        return (iLinTerm - this.m_RulePred.length) % this.getNbOfTargets();
    }

    protected final int getLinDescrDim(int iLinTerm) {
        return (int)Math.floor((double)(iLinTerm - this.m_RulePred.length) / (double)this.getNbOfTargets());
    }

    protected void preparePredictionsForNormalization() {
        if (!this.getSettings().getRules().isOptNormalization() || this.getSettings().getRules().getOptNormalization().equals((Object)SettingsRules.OptimizationNormalization.OnlyScaling)) {
            return;
        }
        for (int iTarg = 0; iTarg < this.getNbOfTargets(); ++iTarg) {
            if (this.getPredictionsWhenCovered(0, 0, iTarg) != this.getMean(iTarg)) {
                System.err.println("Error: Difference in preparePredictionsForNormalization for target nb " + iTarg + ". The values are " + this.getPredictionsWhenCovered(0, 0, iTarg) + " and " + this.getMean(iTarg));
                System.exit(1);
            }
            this.m_RulePred[0].m_prediction[iTarg][0] = Math.sqrt(this.getNormFactor(iTarg));
        }
        if (GDProblem.m_printGDDebugInformation) {
            String fname = this.getSettings().getData().getDataFile();
            try (PrintWriter wrt_pred = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname + ".gd-pred")));
                 PrintWriter wrt_true = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname + ".gd-true")));){
                ClusLogger.fine("Writing predictions to file");
                this.printPredictionsToFile(wrt_pred);
                wrt_pred.close();
                ClusLogger.fine("Writing true values to file");
                this.printTrueValuesToFile(wrt_true);
                wrt_true.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void changeRuleSetToUndoNormNormalization(ClusRuleSet rset) {
        if (!this.getSettings().getRules().isOptNormalization() || this.getSettings().getRules().getOptNormalization().equals((Object)SettingsRules.OptimizationNormalization.OnlyScaling)) {
            return;
        }
        double[] newPred = new double[this.getNbOfTargets()];
        for (int iTarg = 0; iTarg < this.getNbOfTargets(); ++iTarg) {
            newPred[iTarg] = this.getPredictionsWhenCovered(0, 0, iTarg) * rset.getRule(0).getOptWeight() + this.getMean(iTarg);
        }
        rset.getRule(0).setNumericPrediction(newPred);
        rset.getRule(0).setOptWeight(1.0);
    }

    private String printPred(int ruleIndex, int exampleIndex) {
        ClusNumberFormat fr = ClusFormat.THREE_AFTER_DOT;
        String print = "[";
        for (int iTarg = 0; iTarg < this.getNbOfTargets(); ++iTarg) {
            double pred = this.getPredictionsWhenCovered(ruleIndex, exampleIndex, iTarg);
            if (this.getSettings().getRules().isOptNormalization()) {
                pred /= Math.sqrt(this.getNormFactor(iTarg));
            }
            print = print + "" + fr.format(pred);
            if (iTarg == this.getNbOfTargets() - 1) continue;
            print = print + "; ";
        }
        print = print + "]";
        return print;
    }

    public void printPredictionsToFile(PrintWriter wrt) {
        if (this.getSettings().getRules().isOptNormalization()) {
            wrt.print("Norm factors: [");
            for (int iTarget = 0; iTarget < this.getNbOfTargets(); ++iTarget) {
                wrt.print(this.getNormFactor(iTarget));
                if (iTarget == this.getNbOfTargets() - 1) continue;
                wrt.print("; ");
            }
            wrt.print("]\n");
        }
        for (int iRule = 0; iRule < this.getNumVar(); ++iRule) {
            if (iRule < this.m_RulePred.length) {
                wrt.print("Rule nb " + iRule + ": ");
                wrt.print(this.printPred(iRule, 0));
            } else {
                wrt.print("Term nb " + iRule + ": ");
                for (int iInstance = 0; iInstance < this.getNbOfInstances(); ++iInstance) {
                    wrt.print(this.isCovered(iRule, iInstance) ? this.printPred(iRule, 0) : "[NA]");
                }
            }
            wrt.print("\n");
        }
    }

    public void printTrueValuesToFile(PrintWriter wrt) {
        ClusNumberFormat fr = ClusFormat.THREE_AFTER_DOT;
        for (int iTrueVal = 0; iTrueVal < this.getNbOfInstances(); ++iTrueVal) {
            wrt.print("[");
            for (int iTarg = 0; iTarg < this.getNbOfTargets(); ++iTarg) {
                double val = this.getTrueValue(iTrueVal, iTarg);
                if (this.getSettings().getRules().isOptNormalization()) {
                    val /= Math.sqrt(this.getNormFactor(iTarg));
                }
                wrt.print(fr.format(val));
                if (iTarg == this.getNbOfTargets() - 1) continue;
                wrt.print("; ");
            }
            wrt.print("]" + System.lineSeparator());
        }
        wrt.print(System.lineSeparator());
    }

    public static class OptimizationParameter {
        public RulePred[] m_rulePredictions;
        public double[][][][] m_baseFuncPredictions;
        public TrueValues[] m_trueValues;
        public ImplicitLinearTerms m_implicitLinearTerms = null;

        public OptimizationParameter(int nbRule, int nbOtherBaseFunc, int nbInst, int nbTarg, ImplicitLinearTerms implicitLinTerms) {
            this.m_rulePredictions = new RulePred[nbRule];
            for (int jRul = 0; jRul < nbRule; ++jRul) {
                this.m_rulePredictions[jRul] = new RulePred(nbInst, nbTarg);
            }
            this.m_baseFuncPredictions = new double[nbOtherBaseFunc][nbInst][nbTarg][1];
            this.m_trueValues = new TrueValues[nbInst];
            this.m_implicitLinearTerms = implicitLinTerms;
        }

        public OptimizationParameter(RulePred[] rulePredictions, double[][][][] predictions, TrueValues[] trueValues, ImplicitLinearTerms implicitLinTerms) {
            this.m_rulePredictions = rulePredictions;
            this.m_baseFuncPredictions = predictions;
            this.m_trueValues = trueValues;
            this.m_implicitLinearTerms = implicitLinTerms;
        }
    }

    public static class RulePred {
        public BitSet m_cover;
        public double[][] m_prediction;

        public RulePred(int nbInst, int nbTarg) {
            this.m_cover = new BitSet(nbInst);
            this.m_prediction = new double[nbTarg][1];
        }
    }

    public static class TrueValues {
        public DataTuple m_dataExample;
        public double[] m_targets;

        public TrueValues(int nbTarg) {
            this.m_targets = new double[nbTarg];
        }

        public TrueValues(int nbTarg, DataTuple instance) {
            this.m_targets = new double[nbTarg];
            this.m_dataExample = instance;
        }
    }
}

