/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.util.tools.optimization;

import si.ijs.kt.clus.algo.rules.ClusRuleLinearTerm;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.ClusLogger;

public class ImplicitLinearTerms {
    private ClusStatManager m_StatManager = null;

    public ImplicitLinearTerms(RowData data, ClusStatManager statMgr) {
        this.m_StatManager = statMgr;
        int nbTargets = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target).getNbAttributes();
        int nbDescrAttr = statMgr.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive).length;
        ClusLogger.info("\tIn optimization using implicitly the predictions of " + nbDescrAttr + " linear terms for each target, total " + nbDescrAttr * nbTargets + " terms.");
    }

    public void DeleteImplicitLinearTerms() {
        this.m_StatManager = null;
    }

    public double predict(int iLinTerm, DataTuple instance, int iTarget, int nbOfTargets) {
        int iLinTermTargetAttr = iLinTerm % nbOfTargets;
        if (iLinTermTargetAttr != iTarget) {
            return 0.0;
        }
        int iDescriptiveAttr = (int)Math.floor((double)iLinTerm / (double)nbOfTargets);
        double pred = ClusRuleLinearTerm.attributeToLinTermPrediction(this.getSettings(), instance, iDescriptiveAttr, iLinTermTargetAttr, nbOfTargets, true);
        return !Double.isNaN(pred) ? pred : 0.0;
    }

    private Settings getSettings() {
        return this.m_StatManager.getSettings();
    }
}

